/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.tileentity.ITileCallback;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SimpleFluidHandler
implements IFluidHandler {
    @Nullable
    protected ITileCallback tile;
    protected List<FluidStorageCoFH> tanks;

    public SimpleFluidHandler() {
        this(null);
    }

    public SimpleFluidHandler(@Nullable ITileCallback tile) {
        this.tile = tile;
        this.tanks = new ArrayList<FluidStorageCoFH>();
    }

    public SimpleFluidHandler(@Nullable ITileCallback tile, @Nonnull List<FluidStorageCoFH> tanks) {
        this.tile = tile;
        this.tanks = new ArrayList<FluidStorageCoFH>(tanks);
    }

    public boolean hasTanks() {
        return this.tanks.size() > 0;
    }

    public boolean isEmpty() {
        for (FluidStorageCoFH tank : this.tanks) {
            if (tank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void onTankChange(int tank) {
        if (this.tile == null) {
            return;
        }
        this.tile.onTankChange(tank);
    }

    public int getTanks() {
        return this.tanks.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.getTanks()) {
            return FluidStack.EMPTY;
        }
        return this.tanks.get(tank).getFluidStack();
    }

    @Nonnull
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        for (FluidStorageCoFH tank : this.tanks) {
            int ret = tank.fill(resource, action);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        for (FluidStorageCoFH tank : this.tanks) {
            FluidStack ret = tank.drain(resource, action);
            if (ret.isEmpty()) continue;
            return ret;
        }
        return FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (FluidStorageCoFH tank : this.tanks) {
            FluidStack ret = tank.drain(maxDrain, action);
            if (ret.isEmpty()) continue;
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        if (tank < 0 || tank > this.getTanks()) {
            return 0;
        }
        return this.tanks.get(tank).getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (tank < 0 || tank > this.getTanks()) {
            return false;
        }
        return this.tanks.get(tank).isFluidValid(stack);
    }
}

