/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.core.command.SubCommandCrafting;
import cofh.core.command.SubCommandEnderChest;
import cofh.core.command.SubCommandHeal;
import cofh.core.command.SubCommandIgnite;
import cofh.core.command.SubCommandRepair;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CoreConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.IntValue permissionCrafting;
    public static ForgeConfigSpec.IntValue permissionEnderChest;
    public static ForgeConfigSpec.IntValue permissionHeal;
    public static ForgeConfigSpec.IntValue permissionIgnite;
    public static ForgeConfigSpec.IntValue permissionRepair;
    public static boolean improvedFeatherFalling;
    public static boolean improvedMending;
    public static boolean enableFishingExhaustion;
    public static float amountFishingExhaustion;
    public static boolean enableSaplingGrowthMod;
    public static int amountSaplingGrowthMod;
    public static boolean enableEnchantmentDescriptions;
    public static boolean enableItemDescriptions;
    private static ForgeConfigSpec.BooleanValue serverImprovedFeatherFalling;
    private static ForgeConfigSpec.BooleanValue serverImprovedMending;
    private static ForgeConfigSpec.BooleanValue serverEnableFishingExhaustion;
    private static ForgeConfigSpec.DoubleValue serverAmountFishingExhaustion;
    private static ForgeConfigSpec.BooleanValue serverEnableSaplingGrowthMod;
    private static ForgeConfigSpec.IntValue serverAmountSaplingGrowthMod;
    private static ForgeConfigSpec.BooleanValue clientEnableEnchantmentDescriptions;
    private static ForgeConfigSpec.BooleanValue clientEnableItemDescriptions;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(CoreConfig.class);
        registered = true;
        CoreConfig.genServerConfig();
        CoreConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private CoreConfig() {
    }

    private static void genServerConfig() {
        SERVER_CONFIG.push("Commands");
        permissionCrafting = SERVER_CONFIG.comment("The required permission level for the '/cofh crafting' command.").defineInRange("Crafting Permission Level", SubCommandCrafting.permissionLevel, 0, 4);
        permissionEnderChest = SERVER_CONFIG.comment("The required permission level for the '/cofh enderchest' command.").defineInRange("EnderChest Permission Level", SubCommandEnderChest.permissionLevel, 0, 4);
        permissionHeal = SERVER_CONFIG.comment("The required permission level for the '/cofh heal' command.").defineInRange("Heal Permission Level", SubCommandHeal.permissionLevel, 0, 4);
        permissionIgnite = SERVER_CONFIG.comment("The required permission level for the '/cofh ignite' command.").defineInRange("Ignite Permission Level", SubCommandIgnite.permissionLevel, 0, 4);
        permissionRepair = SERVER_CONFIG.comment("The required permission level for the '/cofh repair' command.").defineInRange("Repair Permission Level", SubCommandRepair.permissionLevel, 0, 4);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Enchantments");
        serverImprovedFeatherFalling = SERVER_CONFIG.comment("If TRUE, Feather Falling will prevent Farmland from being trampled. This option will work with alternative versions (overrides) of Feather Falling.").define("Improved Feather Falling", improvedFeatherFalling);
        serverImprovedMending = SERVER_CONFIG.comment("If TRUE, Mending behavior is altered so that XP orbs always repair items if possible, and the most damaged item is prioritized. This option may not work with alternative versions (overrides) of Mending.").define("Improved Mending", improvedMending);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Fishing");
        serverEnableFishingExhaustion = SERVER_CONFIG.comment("If TRUE, Fishing will cause exhaustion.").define("Fishing Exhaustion", enableFishingExhaustion);
        serverAmountFishingExhaustion = SERVER_CONFIG.comment("This option sets the amount of exhaustion caused by fishing, if enabled.").defineInRange("Fishing Exhaustion Amount", (double)amountFishingExhaustion, 0.0, 10.0);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("World");
        serverEnableSaplingGrowthMod = SERVER_CONFIG.comment("If TRUE, Sapling growth will be slowed by a configurable factor.").define("Sapling Growth Reduction", enableSaplingGrowthMod);
        serverAmountSaplingGrowthMod = SERVER_CONFIG.comment("This option sets the growth factor for saplings - they will only grow 1 in N times.").defineInRange("Sapling Growth Reduction Factor", amountSaplingGrowthMod, 1, Integer.MAX_VALUE);
        SERVER_CONFIG.pop();
        serverSpec = SERVER_CONFIG.build();
    }

    private static void genClientConfig() {
        CLIENT_CONFIG.push("Tooltips");
        clientEnableEnchantmentDescriptions = CLIENT_CONFIG.comment("If TRUE, Enchantment descriptions will be added to the tooltip for Enchanted Books containing only a single enchantment.").define("Show Enchantment Descriptions", enableEnchantmentDescriptions);
        clientEnableItemDescriptions = CLIENT_CONFIG.comment("If TRUE, Item descriptions will be added to their tooltips if possible.").define("Show Item Descriptions", enableItemDescriptions);
        CLIENT_CONFIG.pop();
        clientSpec = CLIENT_CONFIG.build();
    }

    private static void refreshServerConfig() {
        SubCommandCrafting.permissionLevel = (Integer)permissionCrafting.get();
        SubCommandEnderChest.permissionLevel = (Integer)permissionEnderChest.get();
        SubCommandHeal.permissionLevel = (Integer)permissionHeal.get();
        SubCommandIgnite.permissionLevel = (Integer)permissionIgnite.get();
        SubCommandRepair.permissionLevel = (Integer)permissionRepair.get();
        improvedFeatherFalling = (Boolean)serverImprovedFeatherFalling.get();
        improvedMending = (Boolean)serverImprovedMending.get();
        enableFishingExhaustion = (Boolean)serverEnableFishingExhaustion.get();
        amountFishingExhaustion = ((Double)serverAmountFishingExhaustion.get()).floatValue();
        enableSaplingGrowthMod = (Boolean)serverEnableSaplingGrowthMod.get();
        amountSaplingGrowthMod = (Integer)serverAmountSaplingGrowthMod.get();
    }

    private static void refreshClientConfig() {
        enableEnchantmentDescriptions = (Boolean)clientEnableEnchantmentDescriptions.get();
        enableItemDescriptions = (Boolean)clientEnableItemDescriptions.get();
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                CoreConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                CoreConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                CoreConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                CoreConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        improvedFeatherFalling = true;
        improvedMending = true;
        enableFishingExhaustion = false;
        amountFishingExhaustion = 0.125f;
        enableSaplingGrowthMod = false;
        amountSaplingGrowthMod = 4;
        enableEnchantmentDescriptions = true;
        enableItemDescriptions = true;
    }
}

