/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ICoFHItem;
import cofh.core.util.constants.Constants;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockItemCoFH
extends BlockItem
implements ICoFHItem {
    protected BooleanSupplier showInGroups = Constants.TRUE;
    protected BooleanSupplier showEnchantEffect = Constants.TRUE;
    protected int burnTime = -1;
    protected int enchantability;
    protected Supplier<ItemGroup> displayGroup;

    public BlockItemCoFH(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public BlockItemCoFH setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public BlockItemCoFH setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public BlockItemCoFH setDisplayGroup(Supplier<ItemGroup> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    public BlockItemCoFH setShowInGroups(BooleanSupplier showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.getAsBoolean() || this.func_179223_d() == null) {
            return;
        }
        super.func_150895_a(group, items);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.showEnchantEffect.getAsBoolean() && stack.func_77948_v();
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.enchantability > 0;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public int getBurnTime(ItemStack itemStack) {
        return this.burnTime;
    }

    protected boolean func_194125_a(ItemGroup group) {
        return group == ItemGroup.field_78027_g || this.getCreativeTabs().stream().anyMatch(tab -> tab == group);
    }

    public Collection<ItemGroup> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }
}

