/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.energy.EnergyContainerItemWrapper;
import cofh.core.energy.IEnergyContainerItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.Utils;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.references.CoreReferences;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class EnergyContainerItem
extends ItemCoFH
implements IEnergyContainerItem {
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    public EnergyContainerItem(Item.Properties builder, int maxEnergy, int extract, int receive) {
        super(builder);
        this.maxEnergy = maxEnergy;
        this.extract = extract;
        this.receive = receive;
    }

    public EnergyContainerItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        this(builder, maxEnergy, maxTransfer, maxTransfer);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.isCreative(stack) ? StringHelper.getTextComponent("info.cofh.infinite_source") : StringHelper.getTextComponent(StringHelper.localize("info.cofh.energy") + ": " + StringHelper.getScaledNumber(this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber(this.getMaxEnergyStored(stack)) + " RF"));
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getEnergyStored(oldStack) > 0 != this.getEnergyStored(newStack) > 0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack) && this.getEnergyStored(stack) > 0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0.0;
        }
        return MathHelper.clamp(1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack), 0.0, 1.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, this);
    }

    @Override
    public int getExtract(ItemStack container) {
        return this.extract;
    }

    @Override
    public int getReceive(ItemStack container) {
        return this.receive;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        int holding = EnchantmentHelper.func_77506_a((Enchantment)CoreReferences.HOLDING, (ItemStack)container);
        return Utils.getEnchantedCapacity(this.maxEnergy, holding);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        if (this.isCreative(container)) {
            return 0;
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(Math.min(maxReceive, this.getReceive(container)), this.getSpace(container));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            this.setDefaultTag(container, 0);
        }
        if (this.isCreative(container)) {
            return maxExtract;
        }
        int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(Math.min(maxExtract, this.getExtract(container)), stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }
}

