/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.IColorableItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.ProxyUtils;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnEggItemCoFH
extends ItemCoFH
implements IColorableItem {
    private final int primaryColor;
    private final int secondaryColor;
    private final Supplier<EntityType<?>> typeSup;
    private static final DefaultDispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
            EntityType<?> entitytype = ((SpawnEggItemCoFH)stack.func_77973_b()).getType(stack.func_77978_p());
            entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
            stack.func_190918_g(1);
            return stack;
        }
    };

    public SpawnEggItemCoFH(Supplier<EntityType<?>> typeSupIn, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(builder);
        this.typeSup = typeSupIn;
        this.primaryColor = primaryColorIn;
        this.secondaryColor = secondaryColorIn;
        ProxyUtils.registerColorable(this);
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileentity;
        World world = context.func_195991_k();
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack itemstack = context.func_195996_i();
        BlockPos blockpos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockState blockstate = world.func_180495_p(blockpos);
        Block block = blockstate.func_177230_c();
        if (block == Blocks.field_150474_ac && (tileentity = world.func_175625_s(blockpos)) instanceof MobSpawnerTileEntity) {
            AbstractSpawner abstractspawner = ((MobSpawnerTileEntity)tileentity).func_145881_a();
            EntityType<?> entitytype1 = this.getType(itemstack.func_77978_p());
            abstractspawner.func_200876_a(entitytype1);
            tileentity.func_70296_d();
            world.func_184138_a(blockpos, blockstate, blockstate, 3);
            itemstack.func_190918_g(1);
            return ActionResultType.SUCCESS;
        }
        BlockPos blockpos1 = blockstate.func_196952_d((IBlockReader)world, blockpos).func_197766_b() ? blockpos : blockpos.func_177972_a(direction);
        EntityType<?> entitytype = this.getType(itemstack.func_77978_p());
        if (entitytype.func_220331_a(world, itemstack, context.func_195999_j(), blockpos1, SpawnReason.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = SpawnEggItemCoFH.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.field_72995_K) {
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof FlowingFluidBlock)) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, blockraytraceresult.func_216354_b(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.func_77978_p());
            if (entitytype.func_220331_a(worldIn, itemstack, playerIn, blockpos, SpawnReason.SPAWN_EGG, false, false) == null) {
                return ActionResult.func_226250_c_((Object)itemstack);
            }
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            return ActionResult.func_226248_a_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    public boolean hasType(@Nullable CompoundNBT p_208077_1_, EntityType<?> type) {
        return Objects.equals(this.getType(p_208077_1_), type);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(ItemStack stack, int tintIndex) {
        return tintIndex == 0 ? this.primaryColor : this.secondaryColor;
    }

    public EntityType<?> getType(@Nullable CompoundNBT tag) {
        CompoundNBT compoundnbt;
        if (tag != null && tag.func_150297_b("EntityTag", 10) && (compoundnbt = tag.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)compoundnbt.func_74779_i("id")).orElse(this.typeSup.get());
        }
        return this.typeSup.get();
    }
}

