/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.network.packet.IPacketClient;
import cofh.core.network.packet.PacketBase;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileStatePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected PacketBuffer buffer;

    public TileStatePacket() {
        super(4, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        World world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof TileCoFH) {
            ((TileCoFH)tile).handleStatePacket(this.buffer);
            BlockState state = tile.func_145831_w().func_180495_p(this.pos);
            tile.func_145831_w().func_184138_a(this.pos, state, state, 3);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.buffer = buf;
        this.pos = this.buffer.func_179259_c();
    }

    public static void sendToClient(TileCoFH tile) {
        if (Utils.isClientWorld(tile.world())) {
            return;
        }
        TileStatePacket packet = new TileStatePacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getStatePacket(new PacketBuffer(Unpooled.buffer()));
        packet.sendToAllAround(packet.pos, 192.0, tile.world().func_201675_m().func_186058_p());
    }
}

