/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.registries;

import cofh.core.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DeferredRegisterCoFH<T extends IForgeRegistryEntry<T>> {
    private final IForgeRegistry<T> type;
    private final String modid;
    private final List<Supplier<? extends T>> entries = new ArrayList<Supplier<? extends T>>();
    private final Map<ResourceLocation, RegistryObject> registryObjects = new HashMap<ResourceLocation, RegistryObject>();

    public DeferredRegisterCoFH(IForgeRegistry<T> reg, String modid) {
        this.type = reg;
        this.modid = modid;
    }

    public synchronized <I extends T> RegistryObject<I> register(String resourceLoc, Supplier<I> sup) {
        return this.register(StringHelper.decompose(this.modid, resourceLoc, ':'), sup);
    }

    private synchronized <I extends T> RegistryObject<I> register(String[] resourceLoc, Supplier<I> sup) {
        return this.register(resourceLoc[0], resourceLoc[1], sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(String modid, String name, Supplier<I> sup) {
        return this.register(new ResourceLocation(modid, name), sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(ResourceLocation resourceLoc, Supplier<I> sup) {
        if (this.registryObjects.containsKey(resourceLoc)) {
            return this.registryObjects.get(resourceLoc);
        }
        this.entries.add(() -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(resourceLoc));
        RegistryObject reg = RegistryObject.of((ResourceLocation)resourceLoc, this.type);
        this.registryObjects.put(resourceLoc, reg);
        return reg;
    }

    public T get(String resourceLoc) {
        return this.get(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private T get(String[] resourceLoc) {
        return this.get(resourceLoc[0], resourceLoc[1]);
    }

    public T get(String modid, String name) {
        return this.get(new ResourceLocation(modid, name));
    }

    public T get(ResourceLocation resourceLoc) {
        RegistryObject reg = this.registryObjects.get(resourceLoc);
        return (T)(reg == null ? null : reg.get());
    }

    public RegistryObject<T> getSup(String resourceLoc) {
        return this.getSup(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private RegistryObject<T> getSup(String[] resourceLoc) {
        return this.getSup(resourceLoc[0], resourceLoc[1]);
    }

    public RegistryObject<T> getSup(String modid, String name) {
        return this.getSup(new ResourceLocation(modid, name));
    }

    @Nullable
    public RegistryObject<T> getSup(ResourceLocation resourceLoc) {
        return this.registryObjects.get(resourceLoc);
    }

    public void register(IEventBus bus) {
        bus.addListener(this::addEntries);
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        if (event.getGenericType() == this.type.getRegistrySuperType()) {
            IForgeRegistry reg = event.getRegistry();
            this.entries.stream().map(Supplier::get).forEach(arg_0 -> ((IForgeRegistry)reg).register(arg_0));
        }
    }
}

