/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.FeatureManager;
import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FeatureRecipeCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("cofh", "flag");
    private final FeatureManager manager;
    private final String flag;

    public FeatureRecipeCondition(FeatureManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return this.manager.getFeature(this.flag).getAsBoolean();
    }

    public static class Serializer
    implements IConditionSerializer<FeatureRecipeCondition> {
        private final FeatureManager manager;
        private final ResourceLocation location;

        public Serializer(FeatureManager manager, ResourceLocation location) {
            this.manager = manager;
            this.location = location;
        }

        public void write(JsonObject json, FeatureRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public FeatureRecipeCondition read(JsonObject json) {
            return new FeatureRecipeCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

