/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.advancements;

import cofh.core.advancements.CriterionListeners;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractCriterionTrigger<T extends CriterionListeners<U>, U extends ICriterionInstance>
implements ICriterionTrigger<U> {
    private final ResourceLocation id;
    private final Function<PlayerAdvancements, T> createNew;
    private final Map<PlayerAdvancements, T> listeners = Maps.newHashMap();

    protected AbstractCriterionTrigger(ResourceLocation id, Function<PlayerAdvancements, T> createNew) {
        this.id = id;
        this.createNew = createNew;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(@Nonnull PlayerAdvancements playerAdvancements, @Nonnull ICriterionTrigger.Listener<U> listener) {
        CriterionListeners listeners = (CriterionListeners)this.listeners.get(playerAdvancements);
        if (listeners == null) {
            listeners = (CriterionListeners)this.createNew.apply(playerAdvancements);
            this.listeners.put(playerAdvancements, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(@Nonnull PlayerAdvancements playerAdvancements, @Nonnull ICriterionTrigger.Listener<U> listener) {
        CriterionListeners listeners = (CriterionListeners)this.listeners.get(playerAdvancements);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    @Nullable
    protected T getListeners(PlayerAdvancements playerAdvancements) {
        return (T)((CriterionListeners)this.listeners.get(playerAdvancements));
    }

    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }
}

