/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GunpowderBlock
extends FallingBlock {
    private static final float EXPLOSION_STRENGTH = 4.0f;

    public GunpowderBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_189876_x(BlockState state, IBlockReader reader, BlockPos pos) {
        return -8356741;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        Item item = stack.func_77973_b();
        if (item != Items.field_151033_d && item != Items.field_151059_bz) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        this.catchFire(state, worldIn, pos, hit.func_216354_b(), (LivingEntity)player);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        if (!player.func_184812_l_()) {
            if (item == Items.field_151033_d) {
                stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(handIn));
            } else {
                stack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void catchFire(BlockState state, World world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        GunpowderBlock.explode(world, pos, igniter);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosionIn) {
        if (!world.field_72995_K) {
            GunpowderBlock.explode(world, pos, explosionIn.func_94613_c());
        }
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K) {
            Entity entity = projectile.func_234616_v_();
            if (projectile.func_70027_ad()) {
                BlockPos blockpos = hit.func_216350_a();
                this.catchFire(state, worldIn, blockpos, hit.func_216354_b(), entity instanceof LivingEntity ? (LivingEntity)entity : null);
                worldIn.func_217377_a(blockpos, false);
            }
        }
    }

    private static void explode(World world, BlockPos pos, @Nullable LivingEntity igniter) {
        if (!world.field_72995_K) {
            world.func_217385_a((Entity)igniter, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4.0f, Explosion.Mode.BREAK);
        }
    }
}

