/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.core.block.IDismantleable;
import cofh.core.block.IWrenchable;
import cofh.core.item.IPlacementItem;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.ChatHelper;
import cofh.core.util.RayTracer;
import cofh.core.util.Utils;
import cofh.core.util.helpers.SecurityHelper;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileBlockCoFH
extends Block
implements IDismantleable,
IWrenchable {
    protected final Supplier<? extends TileCoFH> supplier;

    public TileBlockCoFH(AbstractBlock.Properties builder, Supplier<? extends TileCoFH> supplier) {
        super(builder);
        this.supplier = supplier;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.supplier.get().worldContext(state, world);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (Utils.isClientWorld(worldIn)) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileCoFH) || tile.func_145837_r()) {
            return ActionResultType.PASS;
        }
        if (!((TileCoFH)tile).canPlayerChange(player) && SecurityHelper.hasSecurity(tile)) {
            ChatHelper.sendIndexedChatMessageToPlayer(player, (ITextComponent)new TranslationTextComponent("info.cofh.secure_warning", new Object[]{SecurityHelper.getOwnerName(tile)}));
            return ActionResultType.PASS;
        }
        if (this.onBlockActivatedDelegate(worldIn, pos, state, player, handIn, hit)) {
            return ActionResultType.SUCCESS;
        }
        if (((TileCoFH)tile).canOpenGui()) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tile), (BlockPos)tile.func_174877_v());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected boolean onBlockActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        TileCoFH tile = (TileCoFH)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerChange(player)) {
            return false;
        }
        return tile.onActivatedDelegate(world, pos, state, player, hand, result);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileCoFH tile = (TileCoFH)worldIn.func_175625_s(pos);
        if (tile != null) {
            tile.neighborChanged(blockIn, fromPos);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileCoFH tile;
        if (!(placer instanceof PlayerEntity) || Utils.isClientWorld(worldIn)) {
            return;
        }
        ItemStack offhand = placer.func_184592_cb();
        if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof IPlacementItem) {
            PlayerEntity player = (PlayerEntity)placer;
            ((IPlacementItem)offhand.func_77973_b()).onBlockPlacement(offhand, new ItemUseContext(player, Hand.OFF_HAND, RayTracer.retrace(player)));
        }
        if ((tile = (TileCoFH)worldIn.func_175625_s(pos)) != null) {
            tile.onPlacedBy(worldIn, pos, state, placer, stack);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileCoFH) {
                ((TileCoFH)tile).onReplaced(state, worldIn, pos, newState);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return tile instanceof TileCoFH ? ((TileCoFH)tile).getComparatorInputOverride() : super.func_180641_l(blockState, worldIn, pos);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileCoFH) {
            ((TileCoFH)tile).createItemStackTag(stack);
        }
        return stack;
    }

    @Override
    public boolean canDismantle(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCoFH) {
            return ((TileCoFH)tile).canPlayerChange(player);
        }
        return false;
    }
}

