/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block.crops;

import cofh.core.block.crops.CropsBlockCoFH;
import cofh.core.util.Utils;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.MathHelper;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropsBlockTall
extends CropsBlockCoFH {
    public static final int DEFAULT_TALL_AGE = 4;
    protected int tallAge = 4;

    public CropsBlockTall(AbstractBlock.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder, type, growLight, growMod);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)this.func_185524_e(), (Comparable)Integer.valueOf(0))).func_206870_a((Property)Constants.TOP, (Comparable)Boolean.valueOf(false)));
    }

    public CropsBlockTall(AbstractBlock.Properties builder, int growLight, float growMod) {
        this(builder, PlantType.CROP, growLight, growMod);
    }

    public CropsBlockTall(AbstractBlock.Properties builder) {
        this(builder, 9, 1.25f);
    }

    public CropsBlockTall tallAge(int tallAge) {
        this.tallAge = tallAge;
        return this;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{Constants.TOP});
    }

    protected boolean isTop(BlockState state) {
        return (Boolean)state.func_177229_b((Property)Constants.TOP);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int age = (Integer)state.func_177229_b((Property)this.func_185524_e()) - (this.isTop(state) ? 2 : 0);
        return Constants.TALL_CROPS_BY_AGE[MathHelper.clamp(age, 0, Constants.TALL_CROPS_BY_AGE.length - 1)];
    }

    @Override
    public IntegerProperty func_185524_e() {
        return Constants.AGE_0_9;
    }

    public int func_185526_g() {
        return 9;
    }

    protected int getTallAge() {
        return this.tallAge;
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1) || this.isTop(state) || !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= this.growLight && !this.canHarvest(state)) {
            int age = this.func_185527_x(state);
            float growthChance = MathHelper.maxF(CropsBlockTall.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos) * this.growMod, 0.1f);
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
                int newAge = age + 1 == this.getPostHarvestAge() ? this.func_185526_g() : age + 1;
                worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
                if (newAge >= this.getTallAge()) {
                    worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_185528_e(newAge).func_206870_a((Property)Constants.TOP, (Comparable)Boolean.valueOf(true)), 2);
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (this.isTop(state)) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        if (this.func_185527_x(state) >= this.getTallAge()) {
            return worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        }
        return pos.func_177956_o() < 255 && super.func_196260_a(state, worldIn, pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return !this.isTop(state);
    }

    @Override
    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (this.canHarvest(state) || this.isTop(state) || !this.func_196260_a(state, (IWorldReader)worldIn, pos)) {
            return;
        }
        BlockPos above = pos.func_177984_a();
        if (!worldIn.func_175623_d(above) && worldIn.func_180495_p(above).func_177230_c() != this) {
            return;
        }
        int newAge = this.func_185527_x(state) + this.func_185529_b((World)worldIn);
        newAge = Math.min(newAge, this.func_185526_g());
        worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
        if (newAge >= this.getTallAge()) {
            worldIn.func_180501_a(above, (BlockState)this.func_185528_e(newAge).func_206870_a((Property)Constants.TOP, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Override
    public boolean harvest(World world, BlockPos pos, BlockState state, int fortune) {
        if (!this.canHarvest(state)) {
            return false;
        }
        if (Utils.isClientWorld(world)) {
            return true;
        }
        if (this.getPostHarvestAge() >= 0) {
            Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos);
            if (this.isTop(state)) {
                world.func_180501_a(pos, this.func_185528_e(this.getPostHarvestAge() + this.getTallAge()), 2);
                world.func_180501_a(pos.func_177977_b(), this.func_185528_e(this.getPostHarvestAge()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.func_177977_b());
            } else {
                world.func_180501_a(pos, this.func_185528_e(this.getPostHarvestAge()), 2);
                world.func_180501_a(pos.func_177984_a(), this.func_185528_e(this.getPostHarvestAge() + this.getTallAge()), 2);
                Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos.func_177984_a());
            }
        } else {
            world.func_175655_b(pos, true);
            world.func_175655_b(this.isTop(state) ? pos.func_177977_b() : pos.func_177984_a(), true);
        }
        return true;
    }
}

