/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block.crops;

import cofh.core.block.crops.CropsBlockCoFH;
import cofh.core.util.helpers.MathHelper;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class StemBlockCoFH
extends StemBlock {
    protected final PlantType type;
    protected int growLight;
    protected float growMod;
    protected Supplier<Block> cropBlock = () -> Blocks.field_150440_ba;
    protected Supplier<Item> seed = () -> Items.field_151081_bc;

    public StemBlockCoFH(AbstractBlock.Properties builder, PlantType type, int growLight, float growMod) {
        super((StemGrownBlock)Blocks.field_150440_ba, builder);
        this.type = type;
        this.growLight = growLight;
        this.growMod = growMod;
    }

    public StemBlockCoFH(AbstractBlock.Properties builder, int growLight, float growMod) {
        this(builder, PlantType.CROP, growLight, growMod);
    }

    public StemBlockCoFH(AbstractBlock.Properties builder) {
        this(builder, PlantType.CROP, 9, 1.0f);
    }

    public StemBlockCoFH crop(Supplier<Block> crop) {
        this.cropBlock = crop;
        return this;
    }

    public StemBlockCoFH seed(Supplier<Item> seed) {
        this.seed = seed;
        return this;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        float growthChance;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= this.growLight && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (growthChance = MathHelper.maxF(CropsBlockCoFH.getGrowthChanceProxy((Block)this, (IBlockReader)worldIn, pos) * this.growMod, 0.1f))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.func_177229_b((Property)field_176484_a);
            if (i < 7) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)field_176484_a, (Comparable)Integer.valueOf(i + 1)), 2);
            } else {
                Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(random);
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState soil = worldIn.func_180495_p(blockpos.func_177977_b());
                Block block = soil.func_177230_c();
                if (worldIn.func_175623_d(blockpos) && (soil.canSustainPlant((IBlockReader)worldIn, blockpos.func_177977_b(), Direction.UP, (IPlantable)this) || block == Blocks.field_150458_ak || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_196658_i)) {
                    worldIn.func_175656_a(blockpos, this.cropBlock.get().func_176223_P());
                    worldIn.func_175656_a(pos, (BlockState)((StemGrownBlock)this.cropBlock.get()).func_196523_e().func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction));
                }
            }
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    protected Item func_176481_j() {
        return this.seed.get();
    }
}

