/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.capability.templates;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.capability.IAreaEffect;
import cofh.core.util.helpers.AreaEffectHelper;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class AreaEffectItemWrapper
implements IAreaEffect,
ICapabilityProvider {
    private final LazyOptional<IAreaEffect> holder = LazyOptional.of(() -> this);
    final ItemStack areaEffectItem;

    public AreaEffectItemWrapper(ItemStack areaEffectItem) {
        this.areaEffectItem = areaEffectItem;
    }

    @Override
    public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, PlayerEntity player) {
        return AreaEffectHelper.getAreaEffectBlocks(this.areaEffectItem, pos, player);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

