/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.CoFHCore;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.IResourceStorage;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ElementResourceStorage
extends ElementBase {
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected IResourceStorage storage;
    protected boolean infinite;
    protected int minDisplay = 1;
    protected BooleanSupplier drawUnderlay = Constants.TRUE;
    protected BooleanSupplier drawOverlay = Constants.TRUE;
    protected BooleanSupplier clearStorage = Constants.FALSE;

    public ElementResourceStorage(IGuiAccess gui, int posX, int posY, IResourceStorage storage) {
        super(gui, posX, posY);
        this.storage = storage;
    }

    public final ElementResourceStorage setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setUnderlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL underlay texture.");
            return this;
        }
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementResourceStorage setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, Constants.TRUE);
    }

    public final ElementResourceStorage setOverlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL overlay texture.");
            return this;
        }
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    public final ElementResourceStorage setClearStorage(BooleanSupplier clearStorage) {
        this.clearStorage = clearStorage;
        return this;
    }

    public ElementResourceStorage setInfinite(boolean infinite) {
        this.infinite = infinite;
        return this;
    }

    public ElementResourceStorage setMinDisplay(int minDisplay) {
        this.minDisplay = minDisplay;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawStorage();
        this.drawUnderlayTexture();
        this.drawResource();
        this.drawOverlayTexture();
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (this.infinite) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.infinite"));
        } else {
            tooltipList.add((ITextComponent)new StringTextComponent(StringHelper.format(this.storage.getStored()) + " / " + StringHelper.format(this.storage.getCapacity()) + " " + this.storage.getUnit()));
        }
        if (this.clearStorage != Constants.FALSE && (Screen.func_231174_t_() || Screen.func_231173_s_())) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.clear_storage").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (Screen.func_231173_s_() && Screen.func_231174_t_()) {
            return this.clearStorage.getAsBoolean();
        }
        return false;
    }

    protected int getScaled(int scale) {
        if (this.storage.getCapacity() <= 0 || this.infinite) {
            return scale;
        }
        double fraction = (double)this.storage.getStored() * (double)scale / (double)this.storage.getCapacity();
        int amount = MathHelper.clamp(MathHelper.round(fraction), 0, scale);
        return fraction > 0.0 ? Math.max(this.minDisplay, amount) : amount;
    }

    protected void drawStorage() {
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
    }

    protected void drawUnderlayTexture() {
        if (this.drawUnderlay.getAsBoolean() && this.underlayTexture != null) {
            RenderHelper.bindTexture(this.underlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected abstract void drawResource();

    protected void drawOverlayTexture() {
        if (this.drawOverlay.getAsBoolean() && this.overlayTexture != null) {
            RenderHelper.bindTexture(this.overlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }
}

