/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.IntSupplier;

public class ElementScaled
extends ElementBase {
    protected IntSupplier quantitySup;
    protected boolean drawBackground = true;
    protected StartDirection direction = StartDirection.BOTTOM;

    public ElementScaled(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public ElementScaled drawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
        return this;
    }

    public ElementScaled setDirection(StartDirection direction) {
        this.direction = direction;
        return this;
    }

    public ElementScaled setQuantity(IntSupplier sup) {
        this.quantitySup = sup;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        RenderHelper.bindTexture(this.texture);
        int quantity = this.quantitySup.getAsInt();
        if (this.drawBackground) {
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
        switch (this.direction) {
            case TOP: {
                this.drawTexturedModalRect(this.posX(), this.posY(), this.width, 0, this.width, quantity);
                return;
            }
            case BOTTOM: {
                this.drawTexturedModalRect(this.posX(), this.posY() + this.height - quantity, this.width, this.height - quantity, this.width, quantity);
                return;
            }
            case LEFT: {
                this.drawTexturedModalRect(this.posX(), this.posY(), this.width, 0, quantity, this.height);
                return;
            }
            case RIGHT: {
                this.drawTexturedModalRect(this.posX() + this.width - quantity, this.posY(), this.width + this.width - quantity, 0, quantity, this.height);
            }
        }
    }

    public static enum StartDirection {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

