/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element.panel;

import cofh.core.client.gui.CoreTextures;
import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.util.control.ISecurable;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.SoundHelper;
import cofh.core.util.helpers.StringHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PanelSecurity
extends PanelBase {
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0xF0F0F0;
    public static int defaultBackgroundColor = 0x50B050;
    private final ISecurable mySecurable;
    private final UUID myPlayer;

    public PanelSecurity(IGuiAccess gui, ISecurable securable, UUID playerID) {
        this(gui, defaultSide, securable, playerID);
    }

    protected PanelSecurity(IGuiAccess gui, int sideIn, ISecurable securable, UUID playerID) {
        super(gui, sideIn);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = defaultBackgroundColor;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.mySecurable = securable;
        this.myPlayer = playerID;
        this.setVisible(this.mySecurable::hasSecurity);
    }

    @Override
    protected void drawBackground(MatrixStack matrixStack) {
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                this.backgroundColor = 0x40A040;
                break;
            }
            case PRIVATE: {
                this.backgroundColor = 0xA04040;
                break;
            }
            case FRIENDS: {
                this.backgroundColor = 0xA0A040;
                break;
            }
            case TEAM: {
                this.backgroundColor = 9482304;
            }
        }
        super.drawBackground(matrixStack);
        if (!this.fullyOpen) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        RenderSystem.color4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.drawTexturedModalRect(34, 18, 16, 20, 44, 44);
        RenderHelper.resetColor();
    }

    @Override
    protected void drawForeground(MatrixStack matrixStack) {
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                this.drawPanelIcon(matrixStack, CoreTextures.ICON_ACCESS_PUBLIC);
                break;
            }
            case PRIVATE: {
                this.drawPanelIcon(matrixStack, CoreTextures.ICON_ACCESS_PRIVATE);
                break;
            }
            case FRIENDS: {
                this.drawPanelIcon(matrixStack, CoreTextures.ICON_ACCESS_FRIENDS);
                break;
            }
            case TEAM: {
                this.drawPanelIcon(matrixStack, CoreTextures.ICON_ACCESS_TEAM);
            }
        }
        if (!this.fullyOpen) {
            return;
        }
        this.getFontRenderer().func_238405_a_(matrixStack, StringHelper.localize("info.cofh.security"), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
        this.getFontRenderer().func_238405_a_(matrixStack, StringHelper.localize("info.cofh.access") + ":", (float)(this.sideOffset() + 6), 66.0f, this.subheaderColor);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 38, 22);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 58, 22);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 38, 42);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON, 58, 42);
        switch (this.mySecurable.getAccess()) {
            case PUBLIC: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 38, 22);
                this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize("info.cofh.access_public"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case PRIVATE: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 58, 22);
                this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize("info.cofh.access_private"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case FRIENDS: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 38, 42);
                this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize("info.cofh.access_friends"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
                break;
            }
            case TEAM: {
                this.gui.drawIcon(matrixStack, CoreTextures.ICON_BUTTON_HIGHLIGHT, 58, 42);
                this.getFontRenderer().func_238421_b_(matrixStack, StringHelper.localize("info.cofh.access_team"), (float)(this.sideOffset() + 14), 78.0f, this.textColor);
            }
        }
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_ACCESS_PUBLIC, 38, 22);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_ACCESS_PRIVATE, 58, 22);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_ACCESS_FRIENDS, 38, 42);
        this.gui.drawIcon(matrixStack, CoreTextures.ICON_ACCESS_TEAM, 58, 42);
        RenderHelper.resetColor();
    }

    @Override
    public void addTooltip(List<ITextComponent> tooltipList, int mouseX, int mouseY) {
        if (!this.fullyOpen) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.owner").func_230529_a_((ITextComponent)new StringTextComponent(": " + this.mySecurable.getOwnerName())));
            switch (this.mySecurable.getAccess()) {
                case PUBLIC: {
                    tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_public").func_240699_a_(TextFormatting.YELLOW));
                    break;
                }
                case PRIVATE: {
                    tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_private").func_240699_a_(TextFormatting.YELLOW));
                    break;
                }
                case FRIENDS: {
                    tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_friends").func_240699_a_(TextFormatting.YELLOW));
                    break;
                }
                case TEAM: {
                    tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_team").func_240699_a_(TextFormatting.YELLOW));
                    break;
                }
            }
            return;
        }
        int x = mouseX - this.posX();
        int y = mouseY - this.posY();
        if (38 <= x && x < 54 && 22 <= y && y < 38) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_public"));
        } else if (58 <= x && x < 74 && 22 <= y && y < 38) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_private"));
        } else if (38 <= x && x < 54 && 42 <= y && y < 58) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_friends"));
        } else if (58 <= x && x < 74 && 42 <= y && y < 58) {
            tooltipList.add((ITextComponent)new TranslationTextComponent("info.cofh.access_team"));
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.myPlayer.equals(this.mySecurable.getOwner().getId())) {
            return true;
        }
        if (!this.fullyOpen) {
            return false;
        }
        double x = mouseX - (double)this.posX();
        double y = mouseY - (double)this.posY();
        if (x < 34.0 || x >= 78.0 || y < 18.0 || y >= 62.0) {
            return false;
        }
        if (38.0 <= x && x < 54.0 && 22.0 <= y && y < 38.0) {
            if (this.mySecurable.getAccess() != ISecurable.AccessMode.PUBLIC) {
                this.mySecurable.setAccess(ISecurable.AccessMode.PUBLIC);
                SoundHelper.playClickSound(0.5f);
            }
        } else if (58.0 <= x && x < 74.0 && 22.0 <= y && y < 38.0) {
            if (this.mySecurable.getAccess() != ISecurable.AccessMode.PRIVATE) {
                this.mySecurable.setAccess(ISecurable.AccessMode.PRIVATE);
                SoundHelper.playClickSound(0.8f);
            }
        } else if (38.0 <= x && x < 54.0 && 42.0 <= y && y < 58.0) {
            if (this.mySecurable.getAccess() != ISecurable.AccessMode.FRIENDS) {
                this.mySecurable.setAccess(ISecurable.AccessMode.FRIENDS);
                SoundHelper.playClickSound(0.6f);
            }
        } else if (58.0 <= x && x < 74.0 && 42.0 <= y && y < 58.0 && this.mySecurable.getAccess() != ISecurable.AccessMode.TEAM) {
            this.mySecurable.setAccess(ISecurable.AccessMode.TEAM);
            SoundHelper.playClickSound(0.7f);
        }
        return true;
    }

    @Override
    public void setFullyOpen() {
        if (!this.myPlayer.equals(this.mySecurable.getOwner().getId())) {
            return;
        }
        super.setFullyOpen();
    }
}

