/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.datagen;

import cofh.core.datagen.CoreBlockStateProvider;
import cofh.core.datagen.CoreItemModelProvider;
import cofh.core.datagen.CoreLootTableProvider;
import cofh.core.datagen.CoreRecipeProvider;
import cofh.core.util.loot.TileNBTSync;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="cofh_core")
public class CoreDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        TileNBTSync.setup();
        if (event.includeServer()) {
            CoreDataGen.registerServerProviders(event);
        }
        if (event.includeClient()) {
            CoreDataGen.registerClientProviders(event);
        }
    }

    private static void registerServerProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        gen.func_200390_a((IDataProvider)new CoreLootTableProvider(gen));
        gen.func_200390_a((IDataProvider)new CoreRecipeProvider(gen));
    }

    private static void registerClientProviders(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper exFileHelper = event.getExistingFileHelper();
        gen.func_200390_a((IDataProvider)new CoreBlockStateProvider(gen, exFileHelper));
        gen.func_200390_a((IDataProvider)new CoreItemModelProvider(gen, exFileHelper));
    }
}

