/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.datagen;

import cofh.core.registries.DeferredRegisterCoFH;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public abstract class ItemModelProviderCoFH
extends ItemModelProvider {
    public static final String ARMOR = "armor";
    public static final String AUGMENTS = "augments";
    public static final String COINS = "coins";
    public static final String CRAFTING = "crafting";
    public static final String CROPS = "crops";
    public static final String DUSTS = "dusts";
    public static final String FOODS = "foods";
    public static final String GEARS = "gears";
    public static final String GEMS = "gems";
    public static final String INGOTS = "ingots";
    public static final String MINECARTS = "minecarts";
    public static final String NUGGETS = "nuggets";
    public static final String PLATES = "plates";
    public static final String PROJECTILES = "projectiles";
    public static final String RESOURCES = "resources";
    public static final String SEEDS = "seeds";
    public static final String TOOLS = "tools";

    public ItemModelProviderCoFH(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void standardToolSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.handheld((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_shovel"), TOOLS);
        this.handheld((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_pickaxe"), TOOLS);
        this.handheld((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_axe"), TOOLS);
        this.handheld((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_hoe"), TOOLS);
        this.handheld((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_sword"), TOOLS);
    }

    protected void metalSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.metalSet(reg, prefix, false);
    }

    protected void metalSet(DeferredRegisterCoFH<Item> reg, String prefix, boolean vanilla) {
        if (!vanilla) {
            this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_ingot"), INGOTS);
            this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_nugget"), NUGGETS);
        }
        this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_dust"), DUSTS);
        this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_gear"), GEARS);
    }

    protected void gemSet(DeferredRegisterCoFH<Item> reg, String prefix) {
        this.gemSet(reg, prefix, false);
    }

    protected void gemSet(DeferredRegisterCoFH<Item> reg, String prefix, boolean vanilla) {
        if (!vanilla) {
            this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix), GEMS);
        }
        this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_dust"), DUSTS);
        this.generated((Supplier<? extends IItemProvider>)reg.getSup(prefix + "_gear"), GEARS);
    }

    protected String name(Supplier<? extends IItemProvider> item) {
        return item.get().func_199767_j().getRegistryName().func_110623_a();
    }

    protected ResourceLocation itemTexture(Supplier<? extends IItemProvider> item) {
        return this.modLoc("item/" + this.name(item));
    }

    protected ResourceLocation itemTexture(Supplier<? extends IItemProvider> item, String subfolder) {
        return this.modLoc("item/" + subfolder + "/" + this.name(item));
    }

    protected ItemModelBuilder blockItem(Supplier<? extends Block> block) {
        return this.blockItem(block, "");
    }

    protected ItemModelBuilder blockItem(Supplier<? extends Block> block, String suffix) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + suffix));
    }

    protected ItemModelBuilder blockWithInventoryModel(Supplier<? extends Block> block) {
        return (ItemModelBuilder)this.withExistingParent(this.name(block), this.modLoc("block/" + this.name(block) + "_inventory"));
    }

    protected ItemModelBuilder blockSprite(Supplier<? extends Block> block) {
        return this.blockSprite(block, this.modLoc("block/" + this.name(block)));
    }

    protected ItemModelBuilder blockSprite(Supplier<? extends Block> block, ResourceLocation texture) {
        return this.generated(() -> ((Block)block.get()).func_199767_j(), texture);
    }

    protected ItemModelBuilder generated(Supplier<? extends IItemProvider> item, String subfolder) {
        return this.generated(item, this.itemTexture(item, subfolder));
    }

    protected ItemModelBuilder generated(Supplier<? extends IItemProvider> item) {
        return this.generated(item, this.itemTexture(item));
    }

    protected ItemModelBuilder generated(Supplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(this.name(item))).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", texture);
    }

    protected ItemModelBuilder handheld(Supplier<? extends IItemProvider> item) {
        return this.handheld(item, this.itemTexture(item));
    }

    protected ItemModelBuilder handheld(Supplier<? extends IItemProvider> item, String subfolder) {
        return this.handheld(item, this.itemTexture(item, subfolder));
    }

    protected ItemModelBuilder handheld(Supplier<? extends IItemProvider> item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(this.name(item), "item/handheld")).texture("layer0", texture);
    }
}

