/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.datagen;

import cofh.core.registries.DeferredRegisterCoFH;
import cofh.core.util.FlagManager;
import cofh.core.util.FlagRecipeCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.block.Block;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;

public class RecipeProviderCoFH
extends RecipeProvider
implements IConditionBuilder {
    protected final String modid;

    public RecipeProviderCoFH(DataGenerator generatorIn, String modid) {
        super(generatorIn);
        this.modid = modid;
    }

    @SafeVarargs
    protected final Ingredient fromTags(ITag.INamedTag<Item> ... tagsIn) {
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(tagsIn.length);
        for (ITag.INamedTag<Item> tag : tagsIn) {
            ingredients.add(Ingredient.func_199805_a(tag));
        }
        return new CompoundIngredientCoFH(ingredients);
    }

    protected void generatePackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('#'), (IItemProvider)individual).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generatePackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)storage).func_200462_a(Character.valueOf('I'), (IItemProvider)individual).func_200469_a(Character.valueOf('#'), tag).func_200472_a("###").func_200472_a("#I#").func_200472_a("###").func_200465_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200466_a(consumer, this.modid + ":storage/" + storageName + suffix);
    }

    protected void generateUnpackingRecipe(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String suffix) {
        String storageName = RecipeProviderCoFH.name(storage);
        String individualName = RecipeProviderCoFH.name(individual);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)individual, (int)9).func_200487_b((IItemProvider)storage).func_200483_a("has_at_least_9_" + individualName, (ICriterionInstance)this.hasItem(MinMaxBounds.IntBound.func_211340_b((int)9), (IItemProvider)individual)).func_200483_a("has_" + storageName, (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)storage)).func_200484_a(consumer, this.modid + ":storage/" + individualName + suffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag, String packingSuffix, String unpackingSuffix) {
        this.generatePackingRecipe(consumer, storage, individual, tag, packingSuffix);
        this.generateUnpackingRecipe(consumer, storage, individual, unpackingSuffix);
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual, ITag.INamedTag<Item> tag) {
        this.generateStorageRecipes(consumer, storage, individual, tag, "", "_from_block");
    }

    protected void generateStorageRecipes(Consumer<IFinishedRecipe> consumer, Item storage, Item individual) {
        this.generateStorageRecipes(consumer, storage, individual, "", "_from_block");
    }

    protected void generateTypeRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Item block = reg.get(type + "_block");
        Item nugget = reg.get(type + "_nugget");
        Tags.IOptionalNamedTag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tags.IOptionalNamedTag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        Tags.IOptionalNamedTag<Item> nuggetTag = RecipeProviderCoFH.forgeTag("nuggets/" + type);
        if (block != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, block, ingot, (ITag.INamedTag<Item>)ingotTag, "", "_from_block");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, block, gem, (ITag.INamedTag<Item>)gemTag, "", "_from_block");
            }
        }
        if (nugget != null) {
            if (ingot != null) {
                this.generateStorageRecipes(consumer, ingot, nugget, (ITag.INamedTag<Item>)nuggetTag, "_from_nuggets", "_from_ingot");
            } else if (gem != null) {
                this.generateStorageRecipes(consumer, gem, nugget, (ITag.INamedTag<Item>)nuggetTag, "_from_nuggets", "_from_gem");
            }
        }
        this.generateGearRecipe(reg, consumer, type);
    }

    protected void generateGearRecipe(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String type) {
        Item gear = reg.get(type + "_gear");
        if (gear == null) {
            return;
        }
        Item ingot = reg.get(type + "_ingot");
        Item gem = reg.get(type);
        Tags.IOptionalNamedTag<Item> ingotTag = RecipeProviderCoFH.forgeTag("ingots/" + type);
        Tags.IOptionalNamedTag<Item> gemTag = RecipeProviderCoFH.forgeTag("gems/" + type);
        if (ingot != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), ingotTag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(ingot), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(ingotTag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
        if (gem != null) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), gemTag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(gem), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(gemTag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
        }
    }

    protected void generateGearRecipe(Consumer<IFinishedRecipe> consumer, Item gear, Item material, ITag.INamedTag<Item> tag) {
        if (gear == null || material == null || tag == null) {
            return;
        }
        ShapedRecipeBuilder.func_200470_a((IItemProvider)gear).func_200469_a(Character.valueOf('#'), tag).func_200469_a(Character.valueOf('i'), (ITag)Tags.Items.NUGGETS_IRON).func_200472_a(" # ").func_200472_a("#i#").func_200472_a(" # ").func_200465_a("has_" + RecipeProviderCoFH.name(material), (ICriterionInstance)RecipeProviderCoFH.func_200409_a(tag)).func_200466_a(consumer, this.modid + ":parts/" + RecipeProviderCoFH.name(gear));
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, material, xp, "smelting");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, String material, float xp, String folder) {
        Item ore = reg.get(material + "_ore");
        Item ingot = reg.get(material + "_ingot");
        Item gem = reg.get(material);
        Item dust = reg.get(material + "_dust");
        if (ingot != null) {
            if (dust != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, dust, ingot, 0.0f, folder, "_dust");
            }
            if (ore != null) {
                this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, ingot, xp, folder, "_ore");
            }
        } else if (gem != null && ore != null) {
            this.generateSmeltingAndBlastingRecipes(reg, consumer, ore, gem, xp, folder, "_ore");
        }
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, "", "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder) {
        this.generateSmeltingAndBlastingRecipes(reg, consumer, input, output, xp, folder, "");
    }

    protected void generateSmeltingAndBlastingRecipes(DeferredRegisterCoFH<Item> reg, Consumer<IFinishedRecipe> consumer, Item input, Item output, float xp, String folder, String suffix) {
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)200).func_218628_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_smelting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{input}), (IItemProvider)output, (float)xp, (int)100).func_218628_a("has_" + RecipeProviderCoFH.name(input), (ICriterionInstance)RecipeProviderCoFH.func_200403_a((IItemProvider)input)).func_218632_a(consumer, this.modid + ":" + folder + "/" + RecipeProviderCoFH.name(output) + "_from" + suffix + "_blasting");
    }

    public InventoryChangeTrigger.Instance hasItem(MinMaxBounds.IntBound amount, IItemProvider itemIn) {
        return RecipeProviderCoFH.func_200405_a((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(null, itemIn.func_199767_j(), amount, MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a)});
    }

    protected static Tags.IOptionalNamedTag<Item> forgeTag(String name) {
        return ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", name));
    }

    protected static String name(Block block) {
        return block.getRegistryName() == null ? "" : block.getRegistryName().func_110623_a();
    }

    protected static String name(Item item) {
        return item.getRegistryName() == null ? "" : item.getRegistryName().func_110623_a();
    }

    protected ICondition flagEnabled(FlagManager manager, String flag) {
        return new FlagRecipeCondition(manager, flag);
    }

    protected static class CompoundIngredientCoFH
    extends CompoundIngredient {
        public CompoundIngredientCoFH(List<Ingredient> children) {
            super(children);
        }
    }
}

