/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.energy;

import cofh.core.item.IContainerItem;
import cofh.core.util.helpers.MathHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IEnergyContainerItem
extends IContainerItem {
    default public CompoundNBT getOrCreateEnergyTag(ItemStack container) {
        return container.func_196082_o();
    }

    default public int getSpace(ItemStack container) {
        return this.getMaxEnergyStored(container) - this.getEnergyStored(container);
    }

    default public int getScaledEnergyStored(ItemStack container, int scale) {
        return MathHelper.round((double)this.getEnergyStored(container) * (double)scale / (double)this.getMaxEnergyStored(container));
    }

    default public int getEnergyStored(ItemStack container) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        return Math.min(tag.func_74762_e("Energy"), this.getMaxEnergyStored(container));
    }

    public int getExtract(ItemStack var1);

    public int getReceive(ItemStack var1);

    public int getMaxEnergyStored(ItemStack var1);

    default public void setEnergyStored(ItemStack container, int energy) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        tag.func_74768_a("Energy", MathHelper.clamp(energy, 0, this.getMaxEnergyStored(container)));
    }

    default public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        if (this.isCreative(container)) {
            return 0;
        }
        int stored = Math.min(tag.func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int receive = Math.min(Math.min(maxReceive, this.getReceive(container)), this.getSpace(container));
        if (!simulate) {
            tag.func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    default public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        CompoundNBT tag = this.getOrCreateEnergyTag(container);
        if (this.isCreative(container)) {
            return maxExtract;
        }
        int stored = Math.min(tag.func_74762_e("Energy"), this.getMaxEnergyStored(container));
        int extract = Math.min(Math.min(maxExtract, this.getExtract(container)), stored);
        if (!simulate) {
            tag.func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }
}

