/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.capability.IAreaEffect;
import cofh.core.capability.templates.AreaEffectItemWrapper;
import cofh.core.util.helpers.AreaEffectHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.MatrixApplyingVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class AreaEffectClientEvents {
    private AreaEffectClientEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderBlockHighlights(DrawHighlightEvent.HighlightBlock event) {
        if (event.isCanceled()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (!AreaEffectHelper.validAreaEffectItem(stack)) {
            return;
        }
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getTarget().func_216350_a(), (PlayerEntity)player);
        WorldRenderer worldRender = event.getContext();
        MatrixStack matrix = event.getMatrix();
        IVertexBuilder vertexBuilder = worldRender.field_228415_m_.func_228487_b_().getBuffer(RenderType.func_228659_m_());
        Entity viewEntity = renderInfo.func_216773_g();
        World world = player.field_70170_p;
        Vector3d vec3d = renderInfo.func_216785_c();
        double d0 = vec3d.func_82615_a();
        double d1 = vec3d.func_82617_b();
        double d2 = vec3d.func_82616_c();
        matrix.func_227860_a_();
        for (BlockPos pos : areaBlocks) {
            if (!world.func_175723_af().func_177746_a(pos)) continue;
            worldRender.func_228429_a_(matrix, vertexBuilder, viewEntity, d0, d1, d2, pos, world.func_180495_p(pos));
        }
        matrix.func_227865_b_();
        PlayerController controller = Minecraft.func_71410_x().field_71442_b;
        if (controller == null || !controller.field_78778_j) {
            return;
        }
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        AreaEffectClientEvents.drawBlockDamageTexture(controller, event.getContext(), event.getMatrix(), Minecraft.func_71410_x().field_71460_t.func_215316_n(), player.func_130014_f_(), areaBlocks);
    }

    private static void drawBlockDamageTexture(PlayerController controller, WorldRenderer worldRender, MatrixStack matrixStackIn, ActiveRenderInfo renderInfo, World world, List<BlockPos> areaBlocks) {
        double d0 = renderInfo.func_216785_c().field_72450_a;
        double d1 = renderInfo.func_216785_c().field_72448_b;
        double d2 = renderInfo.func_216785_c().field_72449_c;
        int progress = (int)(controller.field_78770_f * 10.0f) - 1;
        if (progress < 0) {
            return;
        }
        progress = Math.min(progress + 1, 9);
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IVertexBuilder vertexBuilder = worldRender.field_228415_m_.func_228489_c_().getBuffer((RenderType)ModelBakery.field_229320_k_.get(progress));
        for (BlockPos pos : areaBlocks) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)pos.func_177958_n() - d0, (double)pos.func_177956_o() - d1, (double)pos.func_177952_p() - d2);
            MatrixStack.Entry matrixEntry = matrixStackIn.func_227866_c_();
            MatrixApplyingVertexBuilder matrixBuilder = new MatrixApplyingVertexBuilder(vertexBuilder, matrixEntry.func_227870_a_(), matrixEntry.func_227872_b_());
            dispatcher.func_228792_a_(world.func_180495_p(pos), pos, (IBlockDisplayReader)world, matrixStackIn, (IVertexBuilder)matrixBuilder);
            matrixStackIn.func_227865_b_();
        }
    }
}

