/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.capability.CapabilityAreaEffect;
import cofh.core.capability.IAreaEffect;
import cofh.core.capability.templates.AreaEffectItemWrapper;
import cofh.core.util.Utils;
import cofh.core.util.helpers.AreaEffectHelper;
import cofh.core.util.references.EnsorcReferences;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class AreaEffectEvents {
    private static final Set<PlayerEntity> HARVESTING_PLAYERS = new ObjectOpenHashSet();
    private static final Set<PlayerEntity> TILLING_PLAYERS = new ObjectOpenHashSet();

    private AreaEffectEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof ServerPlayerEntity) || Utils.isClientWorld(player.field_70170_p)) {
            return;
        }
        if (HARVESTING_PLAYERS.contains(player)) {
            return;
        }
        HARVESTING_PLAYERS.add(player);
        ItemStack stack = player.func_184614_ca();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getPos(), player);
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        for (BlockPos pos : areaBlocks) {
            if (stack.func_190926_b()) break;
            playerMP.field_71134_c.func_180237_b(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!AreaEffectHelper.validAreaEffectMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(event.getPos(), player);
        float curHardness = event.getState().func_185887_b((IBlockReader)player.field_70170_p, event.getPos());
        if (curHardness <= 0.0f) {
            return;
        }
        float maxHardness = AreaEffectEvents.getMaxHardness((IBlockReader)player.field_70170_p, areaBlocks, curHardness);
        if (maxHardness > curHardness) {
            event.setNewSpeed(event.getNewSpeed() * curHardness / maxHardness);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleUseHoeEvent(UseHoeEvent event) {
        boolean weeding;
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getContext().func_195996_i();
        BlockPos target = event.getContext().func_195995_a();
        World world = player.field_70170_p;
        BlockState targetTilled = (BlockState)HoeItem.field_195973_b.get(world.func_180495_p(target).func_177230_c());
        BlockPos up = target.func_177984_a();
        boolean bl = weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.WEEDING, (ItemStack)stack) > 0;
        if (targetTilled == null || !world.func_175623_d(up) && !weeding) {
            return;
        }
        if (Utils.isClientWorld(world)) {
            player.func_184609_a(event.getContext().func_221531_n());
            return;
        }
        if (TILLING_PLAYERS.contains(player)) {
            return;
        }
        TILLING_PLAYERS.add(player);
        ImmutableList<BlockPos> areaBlocks = ((IAreaEffect)stack.getCapability(CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY).orElse((Object)new AreaEffectItemWrapper(stack))).getAreaEffectBlocks(target, player);
        for (BlockPos pos : areaBlocks) {
            if (stack.func_190926_b()) break;
            BlockState tilled = (BlockState)HoeItem.field_195973_b.get(world.func_180495_p(pos).func_177230_c());
            if (tilled == null) continue;
            world.func_175656_a(pos, tilled);
            if (weeding && !world.func_175623_d(up = pos.func_177984_a())) {
                world.func_175655_b(up, !player.field_71075_bZ.field_75098_d);
            }
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(event.getContext().func_221531_n()));
        }
        world.func_175656_a(target, targetTilled);
        if (weeding && !world.func_175623_d(up = target.func_177984_a())) {
            world.func_175655_b(up, !player.field_71075_bZ.field_75098_d);
        }
        world.func_184133_a(player, target, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HARVESTING_PLAYERS.clear();
            TILLING_PLAYERS.clear();
        }
    }

    private static float getMaxHardness(IBlockReader world, List<BlockPos> areaBlocks, float curHardness) {
        float maxHardness = curHardness;
        for (BlockPos pos : areaBlocks) {
            float testHardness = world.func_180495_p(pos).func_185887_b(world, pos);
            if (!(testHardness > maxHardness)) continue;
            maxHardness = testHardness;
        }
        return maxHardness;
    }
}

