/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.init.CoreConfig;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class CoreClientEvents {
    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String enchKey;
        Enchantment ench;
        ListNBT list;
        String infoKey;
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoreConfig.enableItemDescriptions && StringHelper.canLocalize(infoKey = stack.func_77973_b().func_77667_c(stack) + ".desc")) {
            event.getToolTip().add(1, StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreConfig.enableEnchantmentDescriptions && stack.func_77978_p() != null && (list = stack.func_77978_p().func_150295_c("StoredEnchantments", 10)).size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)list.func_150305_b(0).func_74779_i("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.func_77320_a() + ".desc")) {
            event.getToolTip().add(StringHelper.getInfoTextComponent(enchKey));
        }
        if (CoreConfig.enableItemTags && event.getFlags().func_194127_a()) {
            Item item = event.getItemStack().func_77973_b();
            Set blockTags = Block.func_149634_a((Item)item).getTags();
            Set itemTags = item.getTags();
            if (!blockTags.isEmpty() || !itemTags.isEmpty()) {
                List lines = event.getToolTip();
                if (Screen.func_231172_r_()) {
                    if (!blockTags.isEmpty()) {
                        lines.add(StringHelper.getTextComponent("info.cofh.block_tags").func_240699_a_(TextFormatting.GRAY));
                        blockTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).func_240699_a_(TextFormatting.DARK_GRAY)).forEach(lines::add);
                    }
                    if (!itemTags.isEmpty()) {
                        lines.add(StringHelper.getTextComponent("info.cofh.item_tags").func_240699_a_(TextFormatting.GRAY));
                        itemTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).func_240699_a_(TextFormatting.DARK_GRAY)).forEach(lines::add);
                    }
                } else {
                    lines.add(StringHelper.getTextComponent("info.cofh.hold_ctrl_for_tags").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }
}

