/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.registries.DeferredRegisterCoFH;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.RegistryObject;

public abstract class FluidCoFH {
    protected RegistryObject<FlowingFluid> stillFluid;
    protected RegistryObject<FlowingFluid> flowingFluid;
    protected RegistryObject<FlowingFluidBlock> block;
    protected RegistryObject<Item> bucket;
    protected ForgeFlowingFluid.Properties properties;

    protected FluidCoFH() {
    }

    protected FluidCoFH(DeferredRegisterCoFH<Fluid> reg, String key, FluidAttributes.Builder attributes) {
        this.stillFluid = reg.register(key, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowingFluid = reg.register(FluidCoFH.flowing(key), () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.properties = new ForgeFlowingFluid.Properties(this.stillFluid, this.flowingFluid, attributes);
    }

    public static String flowing(String fluid) {
        return fluid + "_flowing";
    }

    public static String bucket(String fluid) {
        return fluid + "_bucket";
    }
}

