/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.fluid.FluidStorageCoFH;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStorageAdjustable
extends FluidStorageCoFH {
    protected IntSupplier maxFill = this::getCapacity;
    protected IntSupplier maxDrain = this::getCapacity;

    public FluidStorageAdjustable(int capacity) {
        this(capacity, e -> true);
    }

    public FluidStorageAdjustable(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    public FluidStorageAdjustable setTransferLimits(IntSupplier maxFill, IntSupplier maxDrain) {
        this.maxFill = maxFill;
        this.maxDrain = maxDrain;
        return this;
    }

    @Override
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() > this.maxFill.getAsInt()) {
            return super.fill(new FluidStack(resource, this.maxFill.getAsInt()), action);
        }
        return super.fill(resource, action);
    }

    @Override
    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain > this.maxDrain.getAsInt()) {
            return super.drain(this.maxDrain.getAsInt(), action);
        }
        return super.drain(maxDrain, action);
    }
}

