/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.fluid.IFluidStackAccess;
import cofh.core.util.IResourceStorage;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.MathHelper;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidStorageCoFH
implements IFluidHandler,
IFluidStackAccess,
IResourceStorage {
    protected final int baseCapacity;
    protected BooleanSupplier enabled = Constants.TRUE;
    protected Supplier<FluidStack> emptyFluid = Constants.EMPTY_FLUID;
    protected Predicate<FluidStack> validator;
    @Nonnull
    protected FluidStack fluid = FluidStack.EMPTY;
    protected int capacity;

    public FluidStorageCoFH(int capacity) {
        this(capacity, e -> true);
    }

    public FluidStorageCoFH(int capacity, Predicate<FluidStack> validator) {
        this.baseCapacity = capacity;
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidStorageCoFH applyModifiers(float storageMod) {
        this.setCapacity(Math.round((float)this.baseCapacity * storageMod));
        return this;
    }

    public FluidStorageCoFH setCapacity(int capacity) {
        this.capacity = MathHelper.clamp(capacity, 0, Integer.MAX_VALUE);
        if (!this.isEmpty()) {
            this.fluid.setAmount(Math.max(0, Math.min(capacity, this.getAmount())));
        }
        return this;
    }

    public FluidStorageCoFH setEmptyFluid(Supplier<FluidStack> emptyFluidSupplier) {
        if (emptyFluidSupplier != null && emptyFluidSupplier.get() != null) {
            this.emptyFluid = emptyFluidSupplier;
        }
        if (this.fluid.isEmpty()) {
            this.setFluidStack(this.emptyFluid.get());
        }
        return this;
    }

    public FluidStorageCoFH setEnabled(BooleanSupplier enabled) {
        if (enabled != null) {
            this.enabled = enabled;
        }
        return this;
    }

    public FluidStorageCoFH setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(@Nonnull FluidStack stack) {
        return this.enabled.getAsBoolean() && this.validator.test(stack);
    }

    public void setFluidStack(FluidStack stack) {
        this.fluid = stack.isEmpty() ? this.emptyFluid.get() : stack;
    }

    public FluidStorageCoFH read(CompoundNBT nbt) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
        this.setFluidStack(fluid);
        return this;
    }

    public CompoundNBT write(CompoundNBT nbt) {
        this.fluid.writeToNBT(nbt);
        nbt.func_74768_a("Capacity", this.baseCapacity);
        return nbt;
    }

    @Override
    public FluidStack getFluidStack() {
        return this.fluid;
    }

    @Override
    public int getAmount() {
        return this.fluid.getAmount();
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource) || !this.enabled.getAsBoolean()) {
            return 0;
        }
        if (action.simulate()) {
            if (this.fluid.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.capacity - this.fluid.getAmount(), resource.getAmount());
        }
        if (this.fluid.isEmpty()) {
            this.fluid = new FluidStack(resource, Math.min(this.capacity, resource.getAmount()));
            return this.fluid.getAmount();
        }
        if (!this.fluid.isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.capacity - this.fluid.getAmount();
        if (resource.getAmount() < filled) {
            this.fluid.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluid.setAmount(this.capacity);
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluid.isEmpty() || !this.enabled.getAsBoolean()) {
            return FluidStack.EMPTY;
        }
        int drained = maxDrain;
        if (this.fluid.getAmount() < drained) {
            drained = this.fluid.getAmount();
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute()) {
            this.fluid.shrink(drained);
            if (this.fluid.isEmpty()) {
                this.setFluidStack(this.emptyFluid.get());
            }
        }
        return stack;
    }

    public int getTankCapacity(int tank) {
        return this.capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    @Override
    public void modify(int amount) {
        this.fluid.setAmount(Math.min(this.fluid.getAmount() + amount, this.capacity));
        if (this.fluid.isEmpty()) {
            this.fluid = this.emptyFluid.get();
        }
    }

    @Override
    public int getCapacity() {
        return this.getTankCapacity(0);
    }

    @Override
    public int getStored() {
        return this.fluid.getAmount();
    }

    @Override
    public String getUnit() {
        return "mB";
    }
}

