/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.fluid.ManagedFluidHandler;
import cofh.core.fluid.SimpleFluidHandler;
import cofh.core.fluid.SimpleTankInv;
import cofh.core.tileentity.ITileCallback;
import cofh.core.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class ManagedTankInv
extends SimpleTankInv {
    protected List<FluidStorageCoFH> inputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> outputTanks = new ArrayList<FluidStorageCoFH>();
    protected List<FluidStorageCoFH> internalTanks = new ArrayList<FluidStorageCoFH>();
    protected IFluidHandler inputHandler;
    protected IFluidHandler outputHandler;
    protected IFluidHandler accessibleHandler;
    protected IFluidHandler internalHandler;
    protected IFluidHandler allHandler;

    public ManagedTankInv(ITileCallback tile) {
        super(tile);
    }

    public ManagedTankInv(ITileCallback tile, String tag) {
        super(tile, tag);
    }

    public void addTank(FluidStorageCoFH tank, StorageGroup group) {
        if (this.allHandler != null) {
            return;
        }
        this.tanks.add(tank);
        switch (group) {
            case INPUT: {
                this.inputTanks.add(tank);
                break;
            }
            case OUTPUT: {
                this.outputTanks.add(tank);
                break;
            }
            case INTERNAL: {
                this.internalTanks.add(tank);
                break;
            }
            case ACCESSIBLE: {
                this.inputTanks.add(tank);
                this.outputTanks.add(tank);
                break;
            }
        }
    }

    protected void optimize() {
        ((ArrayList)this.tanks).trimToSize();
        ((ArrayList)this.inputTanks).trimToSize();
        ((ArrayList)this.outputTanks).trimToSize();
        ((ArrayList)this.internalTanks).trimToSize();
    }

    public void initHandlers() {
        this.optimize();
        this.inputHandler = new ManagedFluidHandler(this.tile, this.inputTanks, Collections.emptyList());
        this.outputHandler = new ManagedFluidHandler(this.tile, Collections.emptyList(), this.outputTanks);
        this.accessibleHandler = new ManagedFluidHandler(this.tile, this.inputTanks, this.outputTanks);
        this.internalHandler = new SimpleFluidHandler(this.tile, this.internalTanks);
        this.allHandler = new SimpleFluidHandler(this.tile, this.tanks);
    }

    public List<FluidStorageCoFH> getInputTanks() {
        return this.inputTanks;
    }

    public List<FluidStorageCoFH> getOutputTanks() {
        return this.outputTanks;
    }

    public List<FluidStorageCoFH> getInternalTanks() {
        return this.internalTanks;
    }

    public IFluidHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            this.initHandlers();
        }
        switch (group) {
            case INPUT: {
                return this.inputHandler;
            }
            case OUTPUT: {
                return this.outputHandler;
            }
            case ACCESSIBLE: {
                return this.accessibleHandler;
            }
            case INTERNAL: {
                return this.internalHandler;
            }
            case ALL: {
                return this.allHandler;
            }
        }
        return EmptyFluidHandler.INSTANCE;
    }
}

