/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.fluid;

import cofh.core.CoFHCore;
import cofh.core.fluid.FluidCoFH;
import cofh.core.util.references.CoreReferences;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class PotionFluid
extends FluidCoFH {
    public static int DEFAULT_COLOR = 0xF800F8;

    public static PotionFluid create() {
        return new PotionFluid("potion", "cofh_core:block/fluids/potion_still", "cofh_core:block/fluids/potion_flow");
    }

    protected PotionFluid(String key, String stillTexture, String flowTexture) {
        this.stillFluid = CoFHCore.FLUIDS.register(key, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowingFluid = CoFHCore.FLUIDS.register(PotionFluid.flowing(key), () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.properties = new ForgeFlowingFluid.Properties((Supplier)this.stillFluid, (Supplier)this.flowingFluid, PotionFluidAttributes.builder(new ResourceLocation(stillTexture), new ResourceLocation(flowTexture))).bucket((Supplier)this.bucket);
    }

    public static int getPotionColor(FluidStack stack) {
        if (stack.getTag() != null && stack.getTag().func_150297_b("CustomPotionColor", 99)) {
            return stack.getTag().func_74762_e("CustomPotionColor");
        }
        return PotionFluid.getPotionFromFluid(stack.getTag()) == Potions.field_185229_a ? DEFAULT_COLOR : PotionUtils.func_185181_a((Collection)PotionUtils.func_185185_a((CompoundNBT)stack.getTag()));
    }

    public static Potion getPotionFromFluid(@Nullable CompoundNBT tag) {
        return tag == null || !tag.func_74764_b("Potion") ? Potions.field_185229_a : Potion.func_185168_a((String)tag.func_74779_i("Potion"));
    }

    public static FluidStack getPotionAsFluid(int amount, Potion type) {
        if (type == null || type == Potions.field_185229_a) {
            return FluidStack.EMPTY;
        }
        if (type == Potions.field_185230_b) {
            return new FluidStack((Fluid)Fluids.field_204546_a, amount);
        }
        return PotionFluid.addPotionToFluidStack(new FluidStack((Fluid)CoreReferences.FLUID_POTION, amount), type);
    }

    public static FluidStack addPotionToFluidStack(FluidStack stack, Potion type) {
        ResourceLocation resourceLoc = type.getRegistryName();
        if (resourceLoc == null) {
            return FluidStack.EMPTY;
        }
        if (type == Potions.field_185229_a) {
            if (stack.getTag() != null) {
                stack.getTag().func_82580_o("Potion");
                if (stack.getTag().isEmpty()) {
                    stack.setTag(null);
                }
            }
        } else {
            if (stack.getTag() == null) {
                stack.setTag(new CompoundNBT());
            }
            stack.getTag().func_74778_a("Potion", resourceLoc.toString());
        }
        return stack;
    }

    public static FluidStack getPotionFluidFromItem(int amount, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item.equals(Items.field_151068_bn)) {
            return PotionFluid.getPotionAsFluid(amount, PotionUtils.func_185191_c((ItemStack)stack));
        }
        return FluidStack.EMPTY;
    }

    protected static class PotionFluidAttributes
    extends FluidAttributes {
        protected PotionFluidAttributes(FluidAttributes.Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        public ITextComponent getDisplayName(FluidStack stack) {
            Potion potion = PotionUtils.func_185187_c((CompoundNBT)stack.getTag());
            if (potion == Potions.field_185229_a || potion == Potions.field_185230_b) {
                return super.getDisplayName(stack);
            }
            return new TranslationTextComponent(potion.func_185174_b(Items.field_151068_bn.func_77658_a() + ".effect."));
        }

        public Rarity getRarity(FluidStack stack) {
            return PotionFluid.getPotionFromFluid(stack.getTag()).func_185170_a().isEmpty() ? Rarity.COMMON : Rarity.UNCOMMON;
        }

        public int getColor(FluidStack stack) {
            return 0xFF000000 | PotionFluid.getPotionColor(stack);
        }

        public static FluidAttributes.Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            return new FluidAttributes.Builder(stillTexture, flowingTexture, PotionFluidAttributes::new){};
        }
    }
}

