/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeItem;

public interface ICoFHItem
extends IForgeItem {
    default public boolean isCreative(ItemStack stack) {
        return false;
    }

    default public boolean hasCustomEntity(ItemStack stack) {
        return SecurityHelper.hasSecurity(stack);
    }

    @Nullable
    default public Entity createEntity(World world, Entity location, ItemStack stack) {
        if (SecurityHelper.hasSecurity(stack)) {
            location.func_184224_h(true);
            ((ItemEntity)location).lifespan = Integer.MAX_VALUE;
        }
        return null;
    }

    default public void addEnergyTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, int extract, int receive, boolean creative) {
        if (extract == receive && extract > 0 || creative) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.transfer") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
        } else if (extract > 0) {
            if (receive > 0) {
                tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + "|" + StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(extract) + "|" + StringHelper.getScaledNumber(receive) + " RF/t"));
            } else {
                tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.send") + ": " + StringHelper.getScaledNumber(extract) + " RF/t"));
            }
        } else if (receive > 0) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.receive") + ": " + StringHelper.getScaledNumber(receive) + " RF/t"));
        }
    }
}

