/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.FluidContainerItem;
import cofh.core.item.IXPContainerItem;
import cofh.core.util.Utils;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.core.util.helpers.XPHelper;
import cofh.core.util.references.CoreReferences;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class XPContainerItem
extends FluidContainerItem
implements IXPContainerItem {
    protected int xpCapacity;

    public XPContainerItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity, FluidHelper.IS_XP);
        this.xpCapacity = fluidCapacity / 20;
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.getScaledNumber(this.getStoredXP(stack)) + " / " + StringHelper.getScaledNumber(this.getCapacityXP(stack))));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 8039506;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (Utils.isFakePlayer((Entity)player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        int curLevel = player.field_71068_ca;
        if (player.func_225608_bj_()) {
            int xp = XPHelper.getExtraPlayerXP(player) > 0 ? Math.min(XPHelper.getTotalXPForLevel(player.field_71068_ca + 1) - XPHelper.getTotalXPForLevel(player.field_71068_ca) - XPHelper.getExtraPlayerXP(player), this.getStoredXP(stack)) : Math.min(XPHelper.getTotalXPForLevel(player.field_71068_ca + 1) - XPHelper.getTotalXPForLevel(player.field_71068_ca), this.getStoredXP(stack));
            XPHelper.setPlayerXP(player, XPHelper.getPlayerXP(player) + xp);
            if (player.field_71068_ca < curLevel + 1 && XPHelper.getPlayerXP(player) >= XPHelper.getTotalXPForLevel(curLevel + 1)) {
                XPHelper.setPlayerLevel(player, curLevel + 1);
            }
            this.modifyXP(stack, -xp);
        } else if (XPHelper.getExtraPlayerXP(player) > 0) {
            int xp = Math.min(XPHelper.getExtraPlayerXP(player), this.getSpaceXP(stack));
            XPHelper.setPlayerXP(player, XPHelper.getPlayerXP(player) - xp);
            if (player.field_71068_ca < curLevel) {
                XPHelper.setPlayerLevel(player, curLevel);
            }
            this.modifyXP(stack, xp);
        } else if (player.field_71068_ca > 0) {
            int xp = Math.min(XPHelper.getTotalXPForLevel(player.field_71068_ca) - XPHelper.getTotalXPForLevel(player.field_71068_ca - 1), this.getSpaceXP(stack));
            XPHelper.setPlayerXP(player, XPHelper.getPlayerXP(player) - xp);
            if (player.field_71068_ca < curLevel - 1) {
                XPHelper.setPlayerLevel(player, curLevel - 1);
            }
            this.modifyXP(stack, xp);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public int getCapacityXP(ItemStack stack) {
        return this.getMaxStored(stack, this.xpCapacity);
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        int xp = this.getStoredXP(container);
        return xp > 0 ? new FluidStack((Fluid)CoreReferences.FLUID_EXPERIENCE, xp * 20) : FluidStack.EMPTY;
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.getCapacityXP(container) * 20;
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int xp = this.getStoredXP(container);
        int filled = Math.min(this.getCapacityXP(container) - xp, resource.getAmount() / 20);
        if (action.execute()) {
            this.modifyXP(container, filled);
        }
        return filled * 20;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int xp = this.getStoredXP(container);
        if (xp <= 0) {
            return FluidStack.EMPTY;
        }
        int drained = Math.min(xp, maxDrain / 20);
        if (action.execute() && !this.isCreative(container)) {
            this.modifyXP(container, -drained);
        }
        return new FluidStack((Fluid)CoreReferences.FLUID_EXPERIENCE, drained * 20);
    }
}

