/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.network.packet.IPacketClient;
import cofh.core.network.packet.PacketBase;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileRedstonePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;
    protected PacketBuffer buffer;

    public TileRedstonePacket() {
        super(3, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        World world = ProxyUtils.getClientWorld();
        if (world == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof TileCoFH) {
            ((TileCoFH)tile).handleRedstonePacket(this.buffer);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.buffer = buf;
        this.pos = this.buffer.func_179259_c();
    }

    public static void sendToClient(TileCoFH tile) {
        if (Utils.isClientWorld(tile.world())) {
            return;
        }
        TileRedstonePacket packet = new TileRedstonePacket();
        packet.pos = tile.pos();
        packet.buffer = tile.getRedstonePacket(new PacketBuffer(Unpooled.buffer()));
        packet.sendToAllAround(packet.pos, 192.0, (RegistryKey<World>)tile.world().func_234923_W_());
    }
}

