/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.network.packet.IPacketServer;
import cofh.core.network.packet.PacketBase;
import cofh.core.util.control.ITransferControllableTile;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TransferControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected boolean transferIn;
    protected boolean transferOut;

    public TransferControlPacket() {
        super(35, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayerEntity player) {
        World world = player.field_70170_p;
        if (!world.func_195588_v(this.pos)) {
            return;
        }
        TileEntity tile = world.func_175625_s(this.pos);
        if (tile instanceof ITransferControllableTile) {
            ((ITransferControllableTile)tile).setControl(this.transferIn, this.transferOut);
        }
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.transferIn);
        buf.writeBoolean(this.transferOut);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.transferIn = buf.readBoolean();
        this.transferOut = buf.readBoolean();
    }

    public static void sendToServer(ITransferControllableTile tile) {
        TransferControlPacket packet = new TransferControlPacket();
        packet.pos = tile.pos();
        packet.transferIn = tile.transferControl().getTransferIn();
        packet.transferOut = tile.transferControl().getTransferOut();
        packet.sendToServer();
    }
}

