/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.registries;

import cofh.core.util.helpers.StringHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;

public class DeferredRegisterCoFH<T extends IForgeRegistryEntry<T>> {
    private final Class<T> superType;
    private final String modid;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    private final Map<ResourceLocation, RegistryObject> registryObjects = new HashMap<ResourceLocation, RegistryObject>();
    private IForgeRegistry<T> type;
    private Supplier<RegistryBuilder<T>> registryFactory;
    private boolean preventDataFixers;

    public static <B extends IForgeRegistryEntry<B>> DeferredRegisterCoFH<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegisterCoFH<B>(reg, modid);
    }

    public static <B extends IForgeRegistryEntry<B>> DeferredRegisterCoFH<B> create(Class<B> base, String modid) {
        return new DeferredRegisterCoFH<B>(base, modid);
    }

    private DeferredRegisterCoFH(Class<T> base, String modid) {
        this.superType = base;
        this.modid = modid;
    }

    private DeferredRegisterCoFH(IForgeRegistry<T> reg, String modid) {
        this(reg.getRegistrySuperType(), modid);
        this.type = reg;
    }

    public DeferredRegisterCoFH<T> preventDataFixers(boolean preventDataFixers) {
        this.preventDataFixers = preventDataFixers;
        return this;
    }

    public synchronized <I extends T> RegistryObject<I> register(String resourceLoc, Supplier<I> sup) {
        return this.register(StringHelper.decompose(this.modid, resourceLoc, ':'), sup);
    }

    private synchronized <I extends T> RegistryObject<I> register(String[] resourceLoc, Supplier<I> sup) {
        return this.register(resourceLoc[0], resourceLoc[1], sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(String modid, String name, Supplier<I> sup) {
        return this.register(new ResourceLocation(modid, name), sup);
    }

    public synchronized <I extends T> RegistryObject<I> register(ResourceLocation resourceLoc, Supplier<I> sup) {
        RegistryObject reg;
        if (this.registryObjects.containsKey(resourceLoc)) {
            return this.registryObjects.get(resourceLoc);
        }
        if (this.type != null) {
            reg = RegistryObject.of((ResourceLocation)resourceLoc, this.type);
        } else if (this.superType != null) {
            reg = RegistryObject.of((ResourceLocation)resourceLoc, this.superType, (String)this.modid);
        } else {
            throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
        }
        this.entries.put(reg, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)sup.get()).setRegistryName(resourceLoc));
        this.registryObjects.put(resourceLoc, reg);
        return reg;
    }

    public Supplier<IForgeRegistry<T>> makeRegistry(String name, Supplier<RegistryBuilder<T>> sup) {
        if (this.superType == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a base type");
        }
        if (this.type != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(new ResourceLocation(this.modid, name)).setType(this.superType);
        return () -> this.type;
    }

    public T get(String resourceLoc) {
        return this.get(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private T get(String[] resourceLoc) {
        return this.get(resourceLoc[0], resourceLoc[1]);
    }

    public T get(String modid, String name) {
        return this.get(new ResourceLocation(modid, name));
    }

    public T get(ResourceLocation resourceLoc) {
        RegistryObject reg = this.registryObjects.get(resourceLoc);
        return (T)(reg == null ? null : reg.get());
    }

    public RegistryObject<T> getSup(String resourceLoc) {
        return this.getSup(StringHelper.decompose(this.modid, resourceLoc, ':'));
    }

    private RegistryObject<T> getSup(String[] resourceLoc) {
        return this.getSup(resourceLoc[0], resourceLoc[1]);
    }

    public RegistryObject<T> getSup(String modid, String name) {
        return this.getSup(new ResourceLocation(modid, name));
    }

    @Nullable
    public RegistryObject<T> getSup(ResourceLocation resourceLoc) {
        return this.registryObjects.get(resourceLoc);
    }

    public void register(IEventBus bus) {
        bus.register((Object)new EventDispatcher(this));
        if (this.type == null && this.registryFactory != null) {
            bus.addListener(this::createRegistry);
        }
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        if (this.type == null && this.registryFactory == null) {
            this.captureRegistry();
        }
        if (this.type != null && event.getGenericType() == this.type.getRegistrySuperType()) {
            IForgeRegistry reg = event.getRegistry();
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                reg.register((IForgeRegistryEntry)e.getValue().get());
                e.getKey().updateReference(reg);
            }
        }
    }

    private void createRegistry(RegistryEvent.NewRegistry event) {
        this.type = this.registryFactory.get().create();
    }

    private void captureRegistry() {
        if (this.superType != null) {
            this.type = RegistryManager.ACTIVE.getRegistry(this.superType);
            if (this.type == null) {
                throw new IllegalStateException("Unable to find registry for type " + this.superType.getName() + " for modid \"" + this.modid + "\" after NewRegistry event");
            }
        } else {
            throw new IllegalStateException("Unable to find registry for mod \"" + this.modid + "\" No lookup criteria specified.");
        }
    }

    public static class EventDispatcher {
        private final DeferredRegisterCoFH<?> register;

        public EventDispatcher(DeferredRegisterCoFH<?> register) {
            this.register = register;
        }

        @SubscribeEvent
        public void handleEvent(RegistryEvent.Register<?> event) {
            if (((DeferredRegisterCoFH)this.register).preventDataFixers) {
                SharedConstants.field_240856_c_ = false;
            }
            ((DeferredRegisterCoFH)this.register).addEntries(event);
            if (((DeferredRegisterCoFH)this.register).preventDataFixers) {
                SharedConstants.field_240856_c_ = true;
            }
        }
    }
}

