/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.tileentity;

import cofh.core.network.packet.client.TileGuiPacket;
import cofh.core.tileentity.ITileCallback;
import cofh.core.util.IConveyableData;
import cofh.core.util.Utils;
import cofh.core.util.control.ISecurable;
import cofh.core.util.helpers.FluidHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileCoFH
extends TileEntity
implements ITileCallback,
IConveyableData {
    protected int numPlayersUsing;
    public static final int TIME_CONSTANT = 32;
    public static final int TIME_CONSTANT_HALF = 16;
    public static final int TIME_CONSTANT_QUARTER = 8;
    public static final int TIME_CONSTANT_EIGHTH = 4;

    public TileCoFH(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && Utils.isClientWorld(this.field_145850_b) && !this.hasClientUpdate()) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        this.func_145829_t();
    }

    public int getPlayersUsing() {
        return this.numPlayersUsing;
    }

    public void addPlayerUsing() {
        ++this.numPlayersUsing;
    }

    public void removePlayerUsing() {
        --this.numPlayersUsing;
    }

    public void receiveGuiNetworkData(int id, int data) {
    }

    public void sendGuiNetworkData(Container container, IContainerListener player) {
        if (player instanceof ServerPlayerEntity && !(player instanceof FakePlayer)) {
            TileGuiPacket.sendToClient(this, (ServerPlayerEntity)player);
        }
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        return this;
    }

    public int getComparatorInputOverride() {
        return 0;
    }

    public void neighborChanged(Block blockIn, BlockPos fromPos) {
    }

    public boolean onActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(handler -> FluidHelper.interactWithHandler(player.func_184586_b(hand), handler, player, hand)).orElse(false);
    }

    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public void onReplaced(BlockState state, World worldIn, BlockPos pos, BlockState newState) {
    }

    public boolean onWrench(PlayerEntity player, Direction side) {
        return false;
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        return stack;
    }

    public boolean hasClientUpdate() {
        return false;
    }

    public boolean canOpenGui() {
        return this instanceof INamedContainerProvider;
    }

    public boolean canPlayerChange(PlayerEntity player) {
        return !(this instanceof ISecurable) || ((ISecurable)((Object)this)).canAccess((Entity)player);
    }

    public boolean playerWithinDistance(PlayerEntity player, double distanceSq) {
        return this.field_174879_c.func_218138_a((IPosition)player.func_213303_ch(), true) <= distanceSq;
    }

    public boolean clearEnergy(int coil) {
        return false;
    }

    public boolean clearSlot(int slot) {
        return false;
    }

    public boolean clearTank(int tank) {
        return false;
    }

    protected final boolean timeCheck() {
        return this.field_145850_b.func_82737_E() % 32L == 0L;
    }

    protected final boolean timeCheckHalf() {
        return this.field_145850_b.func_82737_E() % 16L == 0L;
    }

    protected final boolean timeCheckQuarter() {
        return this.field_145850_b.func_82737_E() % 8L == 0L;
    }

    protected final boolean timeCheckEighth() {
        return this.field_145850_b.func_82737_E() % 4L == 0L;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_195045_e, pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public PacketBuffer getConfigPacket(PacketBuffer buffer) {
        return buffer;
    }

    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        return buffer;
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        return buffer;
    }

    public PacketBuffer getRedstonePacket(PacketBuffer buffer) {
        return buffer;
    }

    public PacketBuffer getStatePacket(PacketBuffer buffer) {
        return buffer;
    }

    public void handleConfigPacket(PacketBuffer buffer) {
    }

    public void handleControlPacket(PacketBuffer buffer) {
    }

    public void handleGuiPacket(PacketBuffer buffer) {
    }

    public void handleRedstonePacket(PacketBuffer buffer) {
    }

    public void handleStatePacket(PacketBuffer buffer) {
    }

    public void setActive(boolean active) {
    }

    @Override
    public Block block() {
        return this.func_195044_w().func_177230_c();
    }

    @Override
    public BlockState state() {
        return this.func_195044_w();
    }

    @Override
    public BlockPos pos() {
        return this.field_174879_c;
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }
}

