/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.helpers.MathHelper;
import cofh.core.util.references.CoreReferences;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AreaUtils {
    public static final int HORZ_MAX = 16;
    public static final int VERT_MAX = 8;

    private AreaUtils() {
    }

    public static void igniteNearbyEntities(Entity entity, World worldIn, BlockPos pos, int radius, int duration) {
        AxisAlignedBB area = new AxisAlignedBB(pos.func_177982_a(-radius, -radius, -radius), pos.func_177982_a(1 + radius, 1 + radius, 1 + radius));
        List mobs = worldIn.func_175647_a(LivingEntity.class, area, EntityPredicates.field_94557_a);
        mobs.removeIf(Entity::func_70090_H);
        mobs.removeIf(Entity::func_230279_az_);
        mobs.removeIf(mob -> mob instanceof EndermanEntity);
        for (LivingEntity mob2 : mobs) {
            mob2.func_70015_d(duration);
        }
    }

    public static void igniteNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius, double chance) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidFirePosition(worldIn, (BlockPos)mutable, chance)) continue;
            worldIn.func_175656_a((BlockPos)mutable, ((FireBlock)Blocks.field_150480_ab).func_196448_a((IBlockReader)worldIn, (BlockPos)mutable));
        }
    }

    public static void igniteSpecial(Entity entity, World worldIn, BlockPos pos, int radius, boolean campfire, boolean tnt, @Nullable Entity igniter) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState state = worldIn.func_180495_p(blockpos);
            if (campfire && AreaUtils.isUnlitCampfire(state)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
                continue;
            }
            if (!tnt || !AreaUtils.isUnlitTNT(state)) continue;
            state.func_177230_c().catchFire(state, worldIn, blockpos, Direction.UP, igniter instanceof LivingEntity ? (LivingEntity)igniter : null);
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static boolean isValidFirePosition(World worldIn, BlockPos pos, double chance) {
        BlockPos below = pos.func_177977_b();
        BlockState state = worldIn.func_180495_p(below);
        if (Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, below), (Direction)Direction.UP)) {
            return state.func_185904_a().func_76217_h() || worldIn.field_73012_v.nextDouble() < chance;
        }
        return false;
    }

    public static boolean isLitCampfire(BlockState state) {
        return state.func_177230_c() instanceof CampfireBlock && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false;
    }

    public static boolean isUnlitCampfire(BlockState state) {
        return state.func_177230_c() instanceof CampfireBlock && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) == false && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) == false;
    }

    public static boolean isUnlitTNT(BlockState state) {
        return state.func_177230_c() instanceof TNTBlock;
    }

    public static void freezeNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius) {
        BlockState state = Blocks.field_150433_aE.func_176223_P();
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !(worldIn.func_226691_t_((BlockPos)mutable).func_225486_c(blockpos) < 0.8f) || !AreaUtils.isValidSnowPosition(worldIn, (BlockPos)mutable)) continue;
            worldIn.func_175656_a((BlockPos)mutable, state);
        }
    }

    public static void freezeSpecial(Entity entity, World worldIn, BlockPos pos, int radius, boolean campfire, boolean fire) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState state = worldIn.func_180495_p(blockpos);
            if (campfire && AreaUtils.isLitCampfire(state)) {
                worldIn.func_175656_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
                continue;
            }
            if (!fire || state.func_177230_c() != Blocks.field_150480_ab) continue;
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static void freezeSurfaceWater(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeAllWater(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        BlockState state = permanent ? Blocks.field_150432_aD.func_176223_P() : Blocks.field_185778_de.func_176223_P();
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150355_j && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151586_h || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)Blocks.field_185778_de, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeSurfaceLava(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreReferences.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static void freezeAllLava(Entity entity, World worldIn, BlockPos pos, int radius, boolean permanent) {
        if (CoreReferences.GLOSSED_MAGMA == null && !permanent) {
            return;
        }
        BlockState state = permanent ? Blocks.field_150343_Z.func_176223_P() : CoreReferences.GLOSSED_MAGMA.func_176223_P();
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            boolean isFull;
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            BlockState blockstate2 = worldIn.func_180495_p(blockpos);
            boolean bl = isFull = blockstate2.func_177230_c() == Blocks.field_150353_l && (Integer)blockstate2.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0;
            if (blockstate2.func_185904_a() != Material.field_151587_i || !isFull || !state.func_196955_c((IWorldReader)worldIn, blockpos) || !worldIn.func_226663_a_(state, blockpos, ISelectionContext.func_216377_a())) continue;
            worldIn.func_175656_a(blockpos, state);
            if (permanent) continue;
            worldIn.func_205220_G_().func_205360_a(blockpos, (Object)CoreReferences.GLOSSED_MAGMA, MathHelper.nextInt(worldIn.field_73012_v, 60, 120));
        }
    }

    public static boolean isValidSnowPosition(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj || block == Blocks.field_180401_cv || block == Blocks.field_185778_de || block == CoreReferences.GLOSSED_MAGMA) {
            return false;
        }
        return Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP) || block == Blocks.field_150433_aE && (Integer)state.func_177229_b((Property)SnowBlock.field_176315_a) == 8;
    }

    private static boolean isValidLightningBoltPosition(World worldIn, BlockPos pos, double chance) {
        BlockPos below = pos.func_177977_b();
        BlockState state = worldIn.func_180495_p(below);
        if (worldIn.func_226660_f_(pos) && Block.func_208061_a((VoxelShape)state.func_196952_d((IBlockReader)worldIn, below), (Direction)Direction.UP)) {
            return worldIn.field_73012_v.nextDouble() < chance;
        }
        return false;
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, BlockState replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2) || worldIn.func_180495_p(iterPos) != replaceable) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformArea(Entity entity, World worldIn, BlockPos pos, Set<BlockState> replaceable, BlockState replacement, int radius, boolean requireAir) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (requireAir) {
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
                if (!(distance < (double)f2)) continue;
                mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
                BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
                if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !replaceable.contains(worldIn.func_180495_p(blockpos))) continue;
                worldIn.func_175656_a(blockpos, replacement);
            }
        } else {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
                if (!iterPos.func_218137_a((IPosition)entity.func_213303_ch(), (double)f) || !replaceable.contains(worldIn.func_180495_p(iterPos))) continue;
                worldIn.func_175656_a(iterPos, replacement);
            }
        }
    }

    public static void transformGrass(Entity entity, World worldIn, BlockPos pos, int radius) {
        AreaUtils.transformArea(entity, worldIn, pos, Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P(), radius, true);
    }

    public static void transformMycelium(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_196658_i.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, Blocks.field_150391_bh.func_176223_P(), radius, true);
    }

    public static void transformSignalAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.SIGNAL_AIR.func_176223_P(), radius, false);
    }

    public static void transformGlowAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.GLOW_AIR.func_176223_P(), radius, false);
    }

    public static void transformEnderAir(Entity entity, World worldIn, BlockPos pos, int radius) {
        ObjectOpenHashSet replaceable = new ObjectOpenHashSet();
        Collections.addAll(replaceable, new BlockState[]{Blocks.field_150350_a.func_176223_P(), Blocks.field_201941_jj.func_176223_P()});
        AreaUtils.transformArea(entity, worldIn, pos, (Set<BlockState>)replaceable, CoreReferences.ENDER_AIR.func_176223_P(), radius, false);
    }

    public static void zapNearbyGround(Entity entity, World worldIn, BlockPos pos, int radius, double chance, int max) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int count = 0;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            if (count >= max) {
                return;
            }
            double distance = blockpos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(blockpos.func_177958_n(), blockpos.func_177956_o() + 1, blockpos.func_177952_p());
            BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidLightningBoltPosition(worldIn, (BlockPos)mutable, chance)) continue;
            worldIn.func_175656_a((BlockPos)mutable, CoreReferences.LIGHTNING_AIR.func_176223_P());
            ++count;
        }
    }

    public static void growMushrooms(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        int grow = 0;
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vector3i)entity.func_233580_cy_().func_177984_a());
        BlockState blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
        if (blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) && AreaUtils.isValidMushroomPosition(worldIn, entity.func_233580_cy_(), 1.0)) {
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2)) continue;
            mutable.func_181079_c(iterPos.func_177958_n(), iterPos.func_177956_o() + 1, iterPos.func_177952_p());
            blockstate1 = worldIn.func_180495_p((BlockPos)mutable);
            if (!blockstate1.isAir((IBlockReader)worldIn, (BlockPos)mutable) || !AreaUtils.isValidMushroomPosition(worldIn, iterPos, 0.5 - distance / (double)f2)) continue;
            worldIn.func_175656_a((BlockPos)mutable, worldIn.field_73012_v.nextBoolean() ? Blocks.field_150338_P.func_176223_P() : Blocks.field_150337_Q.func_176223_P());
            ++grow;
        }
    }

    private static boolean isValidMushroomPosition(World worldIn, BlockPos pos, double chance) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return worldIn.field_73012_v.nextDouble() < chance && (block == Blocks.field_150391_bh || block == Blocks.field_196661_l);
    }

    public static void growPlants(Entity entity, World worldIn, BlockPos pos, int radius) {
        float f = Math.min(16, radius);
        float v = Math.min(8, radius);
        float f2 = f * f;
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            IGrowable growable;
            BlockState state;
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || !((state = worldIn.func_180495_p(iterPos)).func_177230_c() instanceof IGrowable) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, iterPos, state, worldIn.field_72995_K) || worldIn.field_72995_K || !growable.func_180670_a(worldIn, worldIn.field_73012_v, iterPos, state)) continue;
            try {
                growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, iterPos, state);
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }

    public static void growPlants(Entity entity, World worldIn, BlockPos pos, int radius, int count) {
        BlockState state;
        int grow;
        float f2;
        float v;
        float f;
        block7: {
            IGrowable growable;
            f = Math.min(16, radius);
            v = Math.min(8, radius);
            f2 = f * f;
            grow = 0;
            state = worldIn.func_180495_p(entity.func_233580_cy_());
            if (state.func_177230_c() instanceof IGrowable && (growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, state, worldIn.field_72995_K) && !worldIn.field_72995_K && growable.func_180670_a(worldIn, worldIn.field_73012_v, pos, state)) {
                try {
                    growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                    ++grow;
                }
                catch (Exception e) {
                    if (growable instanceof BambooBlock) break block7;
                    throw e;
                }
            }
        }
        for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a((double)(-f), (double)(-v), (double)(-f)), (BlockPos)pos.func_177963_a((double)f, (double)v, (double)f))) {
            IGrowable growable;
            if (grow >= count) {
                return;
            }
            double distance = iterPos.func_218138_a((IPosition)entity.func_213303_ch(), true);
            if (!(distance < (double)f2) || !((state = worldIn.func_180495_p(iterPos)).func_177230_c() instanceof IGrowable) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)worldIn, iterPos, state, worldIn.field_72995_K) || worldIn.field_72995_K || !growable.func_180670_a(worldIn, worldIn.field_73012_v, iterPos, state)) continue;
            try {
                growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, iterPos, state);
                ++grow;
            }
            catch (Exception e) {
                if (growable instanceof BambooBlock) continue;
                throw e;
            }
        }
    }
}

