/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.FlagManager;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;

public class FlagLootCondition
implements ILootCondition {
    private final FlagManager manager;
    private final String flag;

    public FlagLootCondition(FlagManager manager, String flag) {
        this.manager = manager;
        this.flag = flag;
    }

    public boolean test(LootContext lootContext) {
        return this.manager.getFlag(this.flag).getAsBoolean();
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return this.manager.flagConditionType;
    }

    public static class Serializer
    implements ILootSerializer<FlagLootCondition> {
        private final FlagManager manager;

        public Serializer(FlagManager manager) {
            this.manager = manager;
        }

        public void serialize(@Nonnull JsonObject json, @Nonnull FlagLootCondition value, @Nonnull JsonSerializationContext context) {
            json.addProperty("flag", value.flag);
        }

        @Nonnull
        public FlagLootCondition deserialize(@Nonnull JsonObject json, @Nonnull JsonDeserializationContext context) {
            return new FlagLootCondition(this.manager, json.getAsJsonPrimitive("flag").getAsString());
        }
    }
}

