/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.FlagLootCondition;
import cofh.core.util.FlagRecipeCondition;
import cofh.core.util.constants.Constants;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FlagManager {
    private static final Object2ObjectOpenHashMap<String, BooleanSupplier> FLAGS = new Object2ObjectOpenHashMap(64);
    public LootConditionType flagConditionType;

    public FlagManager(String modId) {
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(this, new ResourceLocation(modId, "flag")));
        this.flagConditionType = new LootConditionType((ILootSerializer)new FlagLootCondition.Serializer(this));
        Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)new ResourceLocation(modId, "flag"), (Object)this.flagConditionType);
    }

    private BooleanSupplier getOrCreateFlag(String flag) {
        FLAGS.putIfAbsent((Object)flag, (Object)Constants.FALSE);
        return (BooleanSupplier)FLAGS.get((Object)flag);
    }

    public synchronized void setFlag(String flag, boolean enable) {
        FLAGS.put((Object)flag, (Object)(enable ? Constants.TRUE : Constants.FALSE));
    }

    public synchronized void setFlag(String flag, BooleanSupplier condition) {
        FLAGS.put((Object)flag, (Object)(condition == null ? Constants.FALSE : condition));
    }

    public BooleanSupplier getFlag(String flag) {
        return () -> this.getOrCreateFlag(flag).getAsBoolean();
    }
}

