/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class RayTracer {
    public static BlockRayTraceResult retrace(PlayerEntity player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), RayTraceContext.FluidMode.ANY);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, double reach) {
        return RayTracer.retrace(player, reach, RayTraceContext.FluidMode.ANY);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        return RayTracer.retrace(player, RayTraceContext.BlockMode.COLLIDER, fluidMode);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, double reach, RayTraceContext.FluidMode fluidMode) {
        return RayTracer.retrace(player, reach, RayTraceContext.BlockMode.COLLIDER, fluidMode);
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return player.field_70170_p.func_217299_a(new RayTraceContext(RayTracer.getStartVec(player), RayTracer.getEndVec(player), blockMode, fluidMode, (Entity)player));
    }

    public static BlockRayTraceResult retrace(PlayerEntity player, double reach, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        return player.field_70170_p.func_217299_a(new RayTraceContext(RayTracer.getStartVec(player), RayTracer.getEndVec(player, reach), blockMode, fluidMode, (Entity)player));
    }

    public static Vector3d getStartVec(PlayerEntity player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static Vector3d getEndVec(PlayerEntity player) {
        Vector3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vector3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vector3d getEndVec(PlayerEntity player, double reach) {
        Vector3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vector3d lookVec = player.func_70676_i(1.0f);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vector3d getCorrectedHeadVec(PlayerEntity player) {
        return new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_());
    }

    public static double getBlockReachDistance(PlayerEntity player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistanceClient() : (player instanceof ServerPlayerEntity ? RayTracer.getBlockReachDistanceServer((ServerPlayerEntity)player) : 5.0);
    }

    private static double getBlockReachDistanceServer(ServerPlayerEntity player) {
        return player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistanceClient() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }
}

