/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import cofh.core.util.helpers.MathHelper;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Path;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Utils {
    private Utils() {
    }

    public static boolean isClientWorld(World world) {
        return world.field_72995_K;
    }

    public static boolean isServerWorld(World world) {
        return !world.field_72995_K;
    }

    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    public static String createPrettyJSON(String jsonString) {
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(jsonString).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)json);
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    public static boolean spawnLightningBolt(World world, BlockPos pos) {
        return Utils.spawnLightningBolt(world, pos, null);
    }

    public static boolean spawnLightningBolt(World world, BlockPos pos, Entity caster) {
        if (Utils.isServerWorld(world)) {
            LightningBoltEntity bolt = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
            bolt.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
            bolt.func_204809_d(caster instanceof ServerPlayerEntity ? (ServerPlayerEntity)caster : null);
            world.func_217376_c((Entity)bolt);
        }
        return true;
    }

    public static void spawnBlockParticlesClient(World world, IParticleData particle, BlockPos pos, Random rand, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble();
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            double d3 = (rand.nextDouble() - 0.5) * 0.5;
            double d4 = (rand.nextDouble() - 0.5) * 0.5;
            double d5 = (rand.nextDouble() - 0.5) * 0.5;
            world.func_195594_a(particle, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void spawnParticles(World world, IParticleData particle, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
        if (Utils.isServerWorld(world)) {
            ((ServerWorld)world).func_195598_a(particle, posX, posY + 1.0, posZ, particleCount, xOffset, yOffset, zOffset, speed);
        } else {
            world.func_195594_a(particle, posX + xOffset, posY + yOffset, posZ + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static boolean addToPlayerInventory(PlayerEntity player, ItemStack stack) {
        int index;
        if (stack.func_190926_b() || player == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ArmorItem && ((ItemStack)player.field_71071_by.field_70460_b.get(index = ((ArmorItem)stack.func_77973_b()).func_185083_B_().func_188454_b())).func_190926_b()) {
            player.field_71071_by.field_70460_b.set(index, (Object)stack);
            return true;
        }
        PlayerInventory inv = player.field_71071_by;
        for (int i = 0; i < inv.field_70462_a.size(); ++i) {
            if (!((ItemStack)inv.field_70462_a.get(i)).func_190926_b()) continue;
            inv.field_70462_a.set(i, (Object)stack.func_77946_l());
            return true;
        }
        return false;
    }

    public static boolean addPotionEffectNoEvent(LivingEntity entity, EffectInstance effectInstanceIn) {
        if (!Utils.isPotionApplicableNoEvent(entity, effectInstanceIn)) {
            return false;
        }
        EffectInstance effectinstance = (EffectInstance)entity.func_193076_bZ().get(effectInstanceIn.func_188419_a());
        if (effectinstance == null) {
            entity.func_193076_bZ().put(effectInstanceIn.func_188419_a(), effectInstanceIn);
            entity.func_70670_a(effectInstanceIn);
            return true;
        }
        if (effectinstance.func_199308_a(effectInstanceIn)) {
            entity.func_70695_b(effectinstance, true);
            return true;
        }
        return false;
    }

    public static boolean isPotionApplicableNoEvent(LivingEntity entity, EffectInstance potioneffectIn) {
        if (entity.func_70668_bt() == CreatureAttribute.field_223223_b_) {
            Effect effect = potioneffectIn.func_188419_a();
            return effect != Effects.field_76428_l && effect != Effects.field_76436_u;
        }
        return true;
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vector3d pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, false);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, World world, BlockPos pos) {
        return Utils.dropItemStackIntoWorld(stack, world, new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), true);
    }

    public static boolean dropItemStackIntoWorldWithRandomness(ItemStack stack, World world, Vector3d pos) {
        return Utils.dropItemStackIntoWorld(stack, world, pos, true);
    }

    public static boolean dropItemStackIntoWorld(ItemStack stack, World world, Vector3d pos, boolean velocity) {
        if (stack.func_190926_b()) {
            return false;
        }
        float x2 = 0.5f;
        float y2 = 0.0f;
        float z2 = 0.5f;
        if (velocity) {
            x2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            y2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            z2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        }
        ItemEntity entity = new ItemEntity(world, pos.field_72450_a + (double)x2, pos.field_72448_b + (double)y2, pos.field_72449_c + (double)z2, stack.func_77946_l());
        if (velocity) {
            entity.func_213293_j(world.field_73012_v.nextGaussian() * (double)0.05f, world.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f, world.field_73012_v.nextGaussian() * (double)0.05f);
        } else {
            entity.func_213293_j(-0.05, 0.0, 0.0);
        }
        world.func_217376_c((Entity)entity);
        return true;
    }

    public static boolean dropDismantleStackIntoWorld(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_190926_b()) {
            return false;
        }
        float f = 0.3f;
        double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        ItemEntity dropEntity = new ItemEntity(world, (double)pos.func_177958_n() + x2, (double)pos.func_177956_o() + y2, (double)pos.func_177952_p() + z2, stack);
        dropEntity.func_174867_a(10);
        world.func_217376_c((Entity)dropEntity);
        return true;
    }

    public static boolean teleportEntityTo(Entity entity, BlockPos pos) {
        return Utils.teleportEntityTo(entity, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
    }

    public static boolean teleportEntityTo(Entity entity, double x, double y, double z) {
        if (entity instanceof LivingEntity) {
            return Utils.teleportEntityTo((LivingEntity)entity, x, y, z);
        }
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static boolean teleportEntityTo(LivingEntity entity, double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent(entity, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (entity instanceof ServerPlayerEntity && !Utils.isFakePlayer((Entity)entity)) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.field_71135_a.func_147298_b().func_150724_d() && !player.func_70608_bn()) {
                if (entity.func_184218_aH()) {
                    entity.func_184210_p();
                }
                entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.field_70143_R = 0.0f;
            }
        } else {
            if (entity.func_184218_aH()) {
                entity.func_184210_p();
            }
            entity.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
            entity.field_70143_R = 0.0f;
        }
        entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public static int getEnchantedCapacity(int amount, int holding) {
        return MathHelper.clamp(amount + amount * holding / 2, 0, Integer.MAX_VALUE);
    }

    public static int getHeldEnchantmentLevel(LivingEntity living, Enchantment ench) {
        return Math.max(EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)living.func_184614_ca()), EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)living.func_184592_cb()));
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        stack.func_77966_a(ench, level);
    }

    public static void removeEnchantment(ItemStack stack, Enchantment ench) {
        if (stack.func_77978_p() == null || !stack.func_77978_p().func_150297_b("Enchantments", 9)) {
            return;
        }
        ListNBT list = stack.func_77978_p().func_150295_c("Enchantments", 10);
        String encId = String.valueOf(ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)ench));
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            String id = tag.func_74779_i("id");
            if (!encId.equals(id)) continue;
            list.remove(i);
            break;
        }
        if (list.isEmpty()) {
            stack.func_196083_e("Enchantments");
        }
    }

    public static boolean destroyBlock(World world, BlockPos pos, boolean dropBlock, @Nullable Entity entityIn) {
        BlockState state = world.func_180495_p(pos);
        if (state.isAir((IBlockReader)world, pos) || state.func_185887_b((IBlockReader)world, pos) < 0.0f || entityIn instanceof PlayerEntity && state.func_185903_a((PlayerEntity)entityIn, (IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        FluidState ifluidstate = world.func_204610_c(pos);
        if (dropBlock) {
            TileEntity tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220054_a((BlockState)state, (World)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.field_190927_a);
        }
        return world.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }
}

