/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import java.util.EnumMap;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHelper {
    public static final Direction[] DIR_VALUES = Direction.values();
    public static final byte[] SIDE_LEFT = new byte[]{4, 5, 5, 4, 2, 3};
    public static final byte[] SIDE_RIGHT = new byte[]{5, 4, 4, 5, 3, 2};
    public static final byte[] SIDE_OPPOSITE = new byte[]{1, 0, 3, 2, 5, 4};
    public static final byte[] SIDE_ABOVE = new byte[]{3, 2, 1, 1, 1, 1};
    public static final byte[] SIDE_BELOW = new byte[]{2, 3, 0, 0, 0, 0};
    private static final EnumMap<Direction, Direction> SIDE_LEFT_LOOKUP = BlockHelper.computeMap(SIDE_LEFT);
    private static final EnumMap<Direction, Direction> SIDE_RIGHT_LOOKUP = BlockHelper.computeMap(SIDE_RIGHT);
    private static final EnumMap<Direction, Direction> SIDE_OPPOSITE_LOOKUP = BlockHelper.computeMap(SIDE_OPPOSITE);
    private static final EnumMap<Direction, Direction> SIDE_ABOVE_LOOKUP = BlockHelper.computeMap(SIDE_ABOVE);
    private static final EnumMap<Direction, Direction> SIDE_BELOW_LOOKUP = BlockHelper.computeMap(SIDE_BELOW);
    public static final byte[] ROTATE_CLOCK_Y = new byte[]{0, 1, 4, 5, 3, 2};
    public static final byte[] ROTATE_CLOCK_Z = new byte[]{5, 4, 2, 3, 0, 1};
    public static final byte[] ROTATE_CLOCK_X = new byte[]{2, 3, 1, 0, 4, 5};
    public static final byte[] ROTATE_COUNTER_Y = new byte[]{0, 1, 5, 4, 2, 3};
    public static final byte[] ROTATE_COUNTER_Z = new byte[]{4, 5, 2, 3, 1, 0};
    public static final byte[] ROTATE_COUNTER_X = new byte[]{3, 2, 0, 1, 4, 5};
    public static final byte[] INVERT_AROUND_Y = new byte[]{0, 1, 3, 2, 5, 4};
    public static final byte[] INVERT_AROUND_Z = new byte[]{1, 0, 2, 3, 5, 4};
    public static final byte[] INVERT_AROUND_X = new byte[]{1, 0, 3, 2, 4, 5};

    private BlockHelper() {
    }

    public static ToIntFunction<BlockState> lightValue(BooleanProperty property, int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)property) != false ? lightValue : 0;
    }

    public static ToIntFunction<BlockState> lightValue(int lightValue) {
        return state -> lightValue;
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, Direction dir) {
        pos = pos.func_177972_a(dir);
        return world == null || !world.func_175667_e(pos) ? null : world.func_175625_s(pos);
    }

    public static TileEntity getAdjacentTileEntity(World world, BlockPos pos, int side) {
        return world == null ? null : BlockHelper.getAdjacentTileEntity(world, pos, DIR_VALUES[side]);
    }

    public static TileEntity getAdjacentTileEntity(TileEntity refTile, Direction dir) {
        return refTile == null ? null : BlockHelper.getAdjacentTileEntity(refTile.func_145831_w(), refTile.func_174877_v(), dir);
    }

    public static Direction left(Direction face) {
        return SIDE_LEFT_LOOKUP.get(face);
    }

    public static Direction right(Direction face) {
        return SIDE_RIGHT_LOOKUP.get(face);
    }

    public static Direction opposite(Direction face) {
        return SIDE_OPPOSITE_LOOKUP.get(face);
    }

    public static Direction above(Direction face) {
        return SIDE_ABOVE_LOOKUP.get(face);
    }

    public static Direction below(Direction face) {
        return SIDE_BELOW_LOOKUP.get(face);
    }

    private static EnumMap<Direction, Direction> computeMap(byte[] arr) {
        EnumMap<Direction, Direction> map = new EnumMap<Direction, Direction>(Direction.class);
        for (int i = 0; i < 6; ++i) {
            map.put(DIR_VALUES[i], DIR_VALUES[arr[i]]);
        }
        return map;
    }
}

