/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.item.IMultiModeItem;
import com.google.common.base.Strings;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;

public class ItemHelper {
    private ItemHelper() {
    }

    public static ItemStack consumeItem(ItemStack stack, int amount) {
        boolean largerStack;
        if (amount <= 0) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Item item = stack.func_77973_b();
        boolean bl = largerStack = stack.func_190916_E() > 1;
        if (largerStack) {
            stack.func_190918_g(amount);
            if (stack.func_190926_b()) {
                stack = ItemStack.field_190927_a;
            }
        } else if (item.hasContainerItem(stack)) {
            ItemStack ret = item.getContainerItem(stack);
            if (ret.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (ret.func_77984_f() && ret.func_77952_i() > ret.func_77958_k()) {
                ret = ItemStack.field_190927_a;
            }
            return ret;
        }
        return largerStack ? stack : ItemStack.field_190927_a;
    }

    public static ItemStack cloneStack(Item item) {
        return ItemHelper.cloneStack(item, 1);
    }

    public static ItemStack cloneStack(Block block) {
        return ItemHelper.cloneStack(block, 1);
    }

    public static ItemStack cloneStack(Item item, int stackSize) {
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)item, stackSize);
    }

    public static ItemStack cloneStack(Block block, int stackSize) {
        if (block == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack((IItemProvider)block, stackSize);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b() || stackSize <= 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static ItemStack cloneStack(ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
    }

    public static ItemStack copyTag(ItemStack container, ItemStack other) {
        if (!other.func_190926_b() && other.func_77942_o()) {
            container.func_77982_d(other.func_77978_p().func_74737_b());
        }
        return container;
    }

    public static CompoundNBT setItemStackTagName(CompoundNBT tag, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        if (tag == null) {
            tag = new CompoundNBT();
        }
        if (!tag.func_74764_b("display")) {
            tag.func_218657_a("display", (INBT)new CompoundNBT());
        }
        tag.func_74775_l("display").func_74778_a("Name", name);
        return tag;
    }

    public static boolean itemsEqualWithTags(ItemStack stackA, ItemStack stackB) {
        return ItemHelper.itemsEqual(stackA, stackB) && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean itemsEqual(ItemStack stackA, ItemStack stackB) {
        return ItemStack.func_179545_c((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean areItemStacksEqualIgnoreTags(ItemStack stackA, ItemStack stackB, String ... nbtTagsToIgnore) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (stackA.func_190926_b() || stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (stackA.func_190916_E() != stackB.func_190916_E()) {
            return false;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() == null) {
            return true;
        }
        if (stackA.func_77978_p() == null || stackB.func_77978_p() == null) {
            return false;
        }
        int numberOfKeys = stackA.func_77978_p().func_150296_c().size();
        if (numberOfKeys != stackB.func_77978_p().func_150296_c().size()) {
            return false;
        }
        CompoundNBT tagA = stackA.func_77978_p();
        CompoundNBT tagB = stackB.func_77978_p();
        String[] keys = new String[numberOfKeys];
        keys = tagA.func_150296_c().toArray(keys);
        block0: for (int i = 0; i < numberOfKeys; ++i) {
            for (int j = 0; j < nbtTagsToIgnore.length; ++j) {
                if (nbtTagsToIgnore[j].equals(keys[i])) continue block0;
            }
            if (tagA.func_74775_l(keys[i]).equals((Object)tagB.func_74775_l(keys[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPlayerHoldingSomething(PlayerEntity player) {
        return !ItemHelper.getHeldStack(player).func_190926_b();
    }

    public static ItemStack getMainhandStack(PlayerEntity player) {
        return player.func_184614_ca();
    }

    public static ItemStack getOffhandStack(PlayerEntity player) {
        return player.func_184592_cb();
    }

    public static ItemStack getHeldStack(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static ItemStack getHeldMultiModeStack(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IMultiModeItem)) {
            stack = player.func_184592_cb();
        }
        return stack;
    }

    public static boolean isPlayerHoldingMultiModeItem(PlayerEntity player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b() instanceof IMultiModeItem) {
            return true;
        }
        heldItem = player.func_184592_cb();
        return heldItem.func_77973_b() instanceof IMultiModeItem;
    }

    public static boolean incrHeldMultiModeItemState(PlayerEntity player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        return mainHand.func_77973_b() instanceof IMultiModeItem ? ((IMultiModeItem)mainHand.func_77973_b()).incrMode(mainHand) : offHand.func_77973_b() instanceof IMultiModeItem && ((IMultiModeItem)offHand.func_77973_b()).incrMode(offHand);
    }

    public static boolean decrHeldMultiModeItemState(PlayerEntity player) {
        if (!ItemHelper.isPlayerHoldingSomething(player)) {
            return false;
        }
        ItemStack mainHand = player.func_184614_ca();
        ItemStack offHand = player.func_184592_cb();
        return mainHand.func_77973_b() instanceof IMultiModeItem ? ((IMultiModeItem)mainHand.func_77973_b()).decrMode(mainHand) : offHand.func_77973_b() instanceof IMultiModeItem && ((IMultiModeItem)offHand.func_77973_b()).decrMode(offHand);
    }

    public static void onHeldMultiModeItemChange(PlayerEntity player) {
        ItemStack heldItem = ItemHelper.getHeldMultiModeStack(player);
        ((IMultiModeItem)heldItem.func_77973_b()).onModeChange(player, heldItem);
    }
}

