/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.MathHelper;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public final class RenderHelper {
    public static final double RENDER_OFFSET = 0.001953125;
    public static final ResourceLocation MC_BLOCK_SHEET = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation MC_FONT_DEFAULT = new ResourceLocation("textures/font/ascii.png");
    public static final ResourceLocation MC_FONT_SGA = new ResourceLocation("textures/font/ascii_sga.png");
    public static final ResourceLocation MC_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static int vertexColorIndex;

    private RenderHelper() {
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public static AtlasTexture textureMap() {
        return Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b);
    }

    public static Tessellator tessellator() {
        return Tessellator.func_178181_a();
    }

    public static ItemRenderer renderItem() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    public static void setBlockTextureSheet() {
        RenderHelper.bindTexture(MC_BLOCK_SHEET);
    }

    public static void setDefaultFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_DEFAULT);
    }

    public static void setSGAFontTextureSheet() {
        RenderHelper.bindTexture(MC_FONT_SGA);
    }

    public static void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setGLColorFromInt(color);
        RenderHelper.drawTiledTexture(x, y, RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid)), width, height);
        GL11.glPopMatrix();
    }

    public static int getFluidColor(FluidStack fluid) {
        return fluid.getFluid().getAttributes().getColor(fluid);
    }

    public static void drawIcon(TextureAtlasSprite icon, double z) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(0.0, 16.0, z).func_225583_a_(icon.func_94209_e(), icon.func_94210_h());
        buffer.func_225582_a_(16.0, 16.0, z).func_225583_a_(icon.func_94212_f(), icon.func_94210_h());
        buffer.func_225582_a_(16.0, 0.0, z).func_225583_a_(icon.func_94212_f(), icon.func_94206_g());
        buffer.func_225582_a_(0.0, 0.0, z).func_225583_a_(icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tessellator().func_78381_a();
    }

    public static void drawIcon(double x, double y, double z, TextureAtlasSprite icon, int width, int height) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_(x, y + (double)height, z).func_225583_a_(icon.func_94209_e(), icon.func_94210_h());
        buffer.func_225582_a_(x + (double)width, y + (double)height, z).func_225583_a_(icon.func_94212_f(), icon.func_94210_h());
        buffer.func_225582_a_(x + (double)width, y, z).func_225583_a_(icon.func_94212_f(), icon.func_94206_g());
        buffer.func_225582_a_(x, y, z).func_225583_a_(icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tessellator().func_78381_a();
    }

    public static void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetColor();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawScaledTexturedModalRectFromSprite(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(minU, v).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_(u, v).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_(u, minV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawStencil(int xStart, int yStart, int xEnd, int yEnd, int flag) {
        RenderSystem.disableTexture();
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        GL11.glClearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)false);
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_225582_a_((double)xStart, (double)yEnd, 0.0).func_181675_d();
        buffer.func_225582_a_((double)xEnd, (double)yEnd, 0.0).func_181675_d();
        buffer.func_225582_a_((double)xEnd, (double)yStart, 0.0).func_181675_d();
        buffer.func_225582_a_((double)xStart, (double)yStart, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
    }

    public static void drawFluid(MatrixStack matrixStack, int x, int y, FluidStack fluid, int width, int height) {
        if (fluid.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setGLColorFromInt(color);
        RenderHelper.drawTiledTexture(matrixStack, x, y, RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid)), width, height);
        GL11.glPopMatrix();
    }

    public static void drawIcon(MatrixStack matrixStack, TextureAtlasSprite icon, float z) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, 0.0f, 16.0f, z).func_225583_a_(icon.func_94209_e(), icon.func_94210_h());
        buffer.func_227888_a_(matrix, 16.0f, 16.0f, z).func_225583_a_(icon.func_94212_f(), icon.func_94210_h());
        buffer.func_227888_a_(matrix, 16.0f, 0.0f, z).func_225583_a_(icon.func_94212_f(), icon.func_94206_g());
        buffer.func_227888_a_(matrix, 0.0f, 0.0f, z).func_225583_a_(icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tessellator().func_78381_a();
    }

    public static void drawIcon(MatrixStack matrixStack, float x, float y, float z, TextureAtlasSprite icon, int width, int height) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + (float)height, z).func_225583_a_(icon.func_94209_e(), icon.func_94210_h());
        buffer.func_227888_a_(matrix, x + (float)width, y + (float)height, z).func_225583_a_(icon.func_94212_f(), icon.func_94210_h());
        buffer.func_227888_a_(matrix, x + (float)width, y, z).func_225583_a_(icon.func_94212_f(), icon.func_94206_g());
        buffer.func_227888_a_(matrix, x, y, z).func_225583_a_(icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tessellator().func_78381_a();
    }

    public static void drawTiledTexture(MatrixStack matrixStack, int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                RenderHelper.drawScaledTexturedModalRectFromSprite(matrixStack, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        RenderHelper.resetColor();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawScaledTexturedModalRectFromSprite(MatrixStack matrixStack, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        float u = minU + (maxU - minU) * (float)width / 16.0f;
        float v = minV + (maxV - minV) * (float)height / 16.0f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, (float)x, (float)(y + height), 0.0f).func_225583_a_(minU, v).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), 0.0f).func_225583_a_(u, v).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)y, 0.0f).func_225583_a_(u, minV).func_181675_d();
        buffer.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225583_a_(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawStencil(MatrixStack matrixStack, int xStart, int yStart, int xEnd, int yEnd, int flag) {
        RenderSystem.disableTexture();
        GL11.glStencilFunc((int)519, (int)flag, (int)flag);
        GL11.glStencilOp((int)0, (int)0, (int)7681);
        GL11.glStencilMask((int)flag);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.depthMask((boolean)false);
        GL11.glClearStencil((int)0);
        RenderSystem.clear((int)1024, (boolean)false);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        buffer.func_227888_a_(matrix, (float)xStart, (float)yEnd, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, (float)xEnd, (float)yEnd, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, (float)xEnd, (float)yStart, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, (float)xStart, (float)yStart, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        RenderSystem.enableTexture();
        GL11.glStencilFunc((int)514, (int)flag, (int)flag);
        GL11.glStencilMask((int)0);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.depthMask((boolean)true);
    }

    public static void disableStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }

    public static void enableStandardItemLighting() {
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
    }

    public static void setupGuiFlatDiffuseLighting() {
        net.minecraft.client.renderer.RenderHelper.func_227783_c_();
    }

    public static void setupGui3DDiffuseLighting() {
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
    }

    public static TextureAtlasSprite getTexture(String location) {
        return RenderHelper.textureMap().func_195424_a(new ResourceLocation(location));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return RenderHelper.textureMap().func_195424_a(location);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        return RenderHelper.getTexture(fluid.getAttributes().getStillTexture());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        return RenderHelper.getTexture(fluid.getFluid().getAttributes().getStillTexture(fluid));
    }

    public static boolean textureExists(String location) {
        return RenderHelper.textureExists(new ResourceLocation(location));
    }

    public static boolean textureExists(ResourceLocation location) {
        return !(RenderHelper.getTexture(location) instanceof MissingTextureSprite);
    }

    public static BakedQuad mulColor(BakedQuad quad, int color) {
        VertexFormat from = DefaultVertexFormats.field_176600_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        int[] packedData = (int[])quad.func_178209_a().clone();
        float[] data = new float[4];
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])packedData, (float[])data, (VertexFormat)from, (int)v, (int)vertexColorIndex);
            data[0] = MathHelper.clamp(data[0] * r, 0.0f, 1.0f);
            data[1] = MathHelper.clamp(data[1] * g, 0.0f, 1.0f);
            data[2] = MathHelper.clamp(data[2] * b, 0.0f, 1.0f);
            LightUtil.pack((float[])data, (int[])packedData, (VertexFormat)from, (int)v, (int)vertexColorIndex);
        }
        return new BakedQuad(packedData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.func_239287_f_());
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void resetColor() {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void bindTexture(ResourceLocation texture) {
        RenderHelper.engine().func_110577_a(texture);
    }

    static {
        VertexFormat from = DefaultVertexFormats.field_176600_a;
        vertexColorIndex = -1;
        ImmutableList elements = from.func_227894_c_();
        for (int i = 0; i < from.func_227894_c_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            if (element.func_177375_c() != VertexFormatElement.Usage.COLOR) continue;
            vertexColorIndex = i;
            break;
        }
    }
}

