/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.control.ISecurable;
import cofh.core.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SecurityHelper {
    public static final GameProfile DEFAULT_GAME_PROFILE = new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    private static UUID cachedId;

    private SecurityHelper() {
    }

    public static boolean isDefaultUUID(UUID uuid) {
        return uuid == null || uuid.version() == 4 && uuid.variant() == 0;
    }

    public static boolean isDefaultProfile(GameProfile profile) {
        return DEFAULT_GAME_PROFILE.equals((Object)profile);
    }

    public static UUID getID(Entity entity) {
        if (entity == null) {
            return DEFAULT_GAME_PROFILE.getId();
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (player instanceof ServerPlayerEntity) {
                return player.func_146103_bH().getId();
            }
            return SecurityHelper.getClientID(player);
        }
        return entity.func_110124_au();
    }

    private static UUID getClientID(PlayerEntity player) {
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return player.func_146103_bH().getId();
        }
        if (cachedId == null) {
            cachedId = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        }
        return cachedId;
    }

    public static boolean hasSecurity(TileEntity tile) {
        if (tile instanceof ISecurable) {
            return !SecurityHelper.isDefaultProfile(((ISecurable)tile).getOwner());
        }
        return false;
    }

    public static String getOwnerName(TileEntity tile) {
        if (SecurityHelper.hasSecurity(tile)) {
            return ((ISecurable)tile).getOwnerName();
        }
        return DEFAULT_GAME_PROFILE.getName();
    }

    public static CompoundNBT getSecurityTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt != null) {
            return nbt.func_74764_b("Security") ? nbt.func_74775_l("Security") : null;
        }
        return stack.func_179543_a("Security");
    }

    public static boolean hasSecurity(ItemStack stack) {
        return SecurityHelper.getSecurityTag(stack) != null;
    }

    public static void setAccess(ItemStack stack, ISecurable.AccessMode access) {
        CompoundNBT secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            secureTag.func_74774_a("SecAccess", (byte)access.ordinal());
        }
    }

    public static void setOwner(ItemStack stack, GameProfile profile) {
        CompoundNBT secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            secureTag.func_74778_a("SecUUID", profile.getId().toString());
            secureTag.func_74778_a("SecName", profile.getName());
        }
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        CompoundNBT secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            return ISecurable.AccessMode.VALUES[secureTag.func_74771_c("SecAccess")];
        }
        return ISecurable.AccessMode.PUBLIC;
    }

    public static GameProfile getOwner(ItemStack stack) {
        CompoundNBT secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            String uuid = secureTag.func_74779_i("SecUUID");
            String name = secureTag.func_74779_i("SecName");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(PreYggdrasilConverter.func_187473_a((MinecraftServer)ServerLifecycleHooks.getCurrentServer(), (String)name), name);
            }
        }
        return DEFAULT_GAME_PROFILE;
    }

    public static String getOwnerName(ItemStack stack) {
        CompoundNBT secureTag = SecurityHelper.getSecurityTag(stack);
        if (secureTag != null) {
            return secureTag.func_74779_i("SecName");
        }
        return StringHelper.localize("info.cofh.another_player");
    }
}

