/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import net.minecraft.entity.player.PlayerEntity;

public class XPHelper {
    private XPHelper() {
    }

    public static int getPlayerXP(PlayerEntity player) {
        return XPHelper.getTotalXPForLevel(player.field_71068_ca) + XPHelper.getExtraPlayerXP(player);
    }

    public static int getLevelPlayerXP(PlayerEntity player) {
        return XPHelper.getTotalXPForLevel(player.field_71068_ca);
    }

    public static int getExtraPlayerXP(PlayerEntity player) {
        return Math.round(player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void setPlayerXP(PlayerEntity player, int exp) {
        player.field_71068_ca = 0;
        player.field_71106_cc = 0.0f;
        player.field_71067_cb = 0;
        XPHelper.addXPToPlayer(player, exp);
    }

    public static void setPlayerLevel(PlayerEntity player, int level) {
        player.field_71068_ca = level;
        player.field_71106_cc = 0.0f;
    }

    public static void addXPToPlayer(PlayerEntity player, int exp) {
        int i = Integer.MAX_VALUE - player.field_71067_cb;
        if (exp > i) {
            exp = i;
        }
        player.field_71106_cc += (float)exp / (float)player.func_71050_bK();
        player.field_71067_cb += exp;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            XPHelper.addXPLevelToPlayer(player, 1);
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static void addXPLevelToPlayer(PlayerEntity player, int levels) {
        player.field_71068_ca += levels;
        if (player.field_71068_ca < 0) {
            player.field_71068_ca = 0;
            player.field_71106_cc = 0.0f;
            player.field_71067_cb = 0;
        }
    }

    public static int getTotalXPForLevel(int level) {
        return level >= 32 ? (9 * level * level - 325 * level + 4440) / 2 : (level >= 17 ? (5 * level * level - 81 * level + 720) / 2 : level * level + 6 * level);
    }
}

