/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConsecrationConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Config CONFIG;
    private static final String CONFIG_PREFIX = "gui.consecration.config.";
    public static Set<ResourceLocation> dimensions;
    public static PermissionMode dimensionPermission;
    public static int fireSmiteDuration;
    public static int holySmiteDuration;
    public static List<? extends String> holyEntities;
    public static List<? extends String> holyEffects;
    public static List<? extends String> holyItems;
    public static List<? extends String> holyEnchantments;
    public static List<? extends String> holyDamage;
    public static List<? extends String> holyMaterials;
    public static boolean defaultUndead;
    public static List<? extends String> undeadList;
    public static double damageReduction;
    public static double healthRegen;
    public static double speedModifier;
    public static boolean bystanderNerf;

    public static void bake() {
        dimensions = new HashSet<ResourceLocation>();
        ((List)ConsecrationConfig.CONFIG.dimensions.get()).forEach(dimension -> dimensions.add(new ResourceLocation(dimension)));
        dimensionPermission = (PermissionMode)((Object)ConsecrationConfig.CONFIG.dimensionPermission.get());
        fireSmiteDuration = (Integer)ConsecrationConfig.CONFIG.fireSmiteDuration.get();
        holySmiteDuration = (Integer)ConsecrationConfig.CONFIG.holySmiteDuration.get();
        holyEntities = (List)ConsecrationConfig.CONFIG.holyEntities.get();
        holyEffects = (List)ConsecrationConfig.CONFIG.holyEffects.get();
        holyItems = (List)ConsecrationConfig.CONFIG.holyItems.get();
        holyEnchantments = (List)ConsecrationConfig.CONFIG.holyEnchantments.get();
        holyDamage = (List)ConsecrationConfig.CONFIG.holyDamage.get();
        holyMaterials = (List)ConsecrationConfig.CONFIG.holyMaterials.get();
        defaultUndead = (Boolean)ConsecrationConfig.CONFIG.defaultUndead.get();
        undeadList = (List)ConsecrationConfig.CONFIG.undeadList.get();
        damageReduction = (Double)ConsecrationConfig.CONFIG.damageReduction.get();
        healthRegen = ((Integer)ConsecrationConfig.CONFIG.healthRegen.get()).intValue();
        speedModifier = (Double)ConsecrationConfig.CONFIG.speedModifier.get();
        bystanderNerf = (Boolean)ConsecrationConfig.CONFIG.bystanderNerf.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Config)specPair.getLeft();
    }

    public static class Config {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> dimensions;
        public final ForgeConfigSpec.EnumValue<PermissionMode> dimensionPermission;
        public final ForgeConfigSpec.IntValue fireSmiteDuration;
        public final ForgeConfigSpec.IntValue holySmiteDuration;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEntities;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEffects;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyItems;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyEnchantments;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyDamage;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> holyMaterials;
        public final ForgeConfigSpec.BooleanValue defaultUndead;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> undeadList;
        public final ForgeConfigSpec.DoubleValue damageReduction;
        public final ForgeConfigSpec.IntValue healthRegen;
        public final ForgeConfigSpec.DoubleValue speedModifier;
        public final ForgeConfigSpec.BooleanValue bystanderNerf;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.push("dimension");
            this.dimensions = builder.comment("Set which dimensions are blacklisted or whitelisted for affected undead").translation("gui.consecration.config.dimensions").defineList("dimensions", ArrayList::new, s -> s instanceof String);
            this.dimensionPermission = builder.comment("Set whether the dimension configuration is blacklisted or whitelisted").translation("gui.consecration.config.dimensionPermission").defineEnum("dimensionPermission", (Enum)PermissionMode.BLACKLIST);
            builder.pop();
            builder.push("holy");
            this.fireSmiteDuration = builder.comment("The amount of time, in seconds, that smiting from fire lasts").translation("gui.consecration.config.fireSmiteDuration").defineInRange("fireSmiteDuration", 10, 0, 100);
            this.holySmiteDuration = builder.comment("The amount of time, in seconds, that smiting from holy sources lasts").translation("gui.consecration.config.holySmiteDuration").defineInRange("holySmiteDuration", 10, 0, 100);
            this.holyEntities = builder.comment("A list of entities that will be able to damage and smite undead").translation("gui.consecration.config.holyEntities").defineList("holyEntities", ArrayList::new, s -> s instanceof String);
            this.holyEffects = builder.comment("A list of potion effects that will be able to damage and smite undead").translation("gui.consecration.config.holyEffects").defineList("holyEffects", Arrays.asList("minecraft:instant_health", "consecration:holy"), s -> s instanceof String);
            this.holyItems = builder.comment("A list of items that will be able to damage and smite undead").translation("gui.consecration.config.holyItems").defineList("holyItems", ArrayList::new, s -> s instanceof String);
            this.holyEnchantments = builder.comment("A list of enchantments that will be able to damage and smite undead").translation("gui.consecration.config.holyEnchantments").defineList("holyEnchantments", Collections.singletonList("minecraft:smite"), s -> s instanceof String);
            this.holyDamage = builder.comment("A list of damage types that will be able to damage and smite undead").translation("gui.consecration.config.holyDamage").defineList("holyDamage", Collections.singletonList("holy"), s -> s instanceof String);
            this.holyMaterials = builder.comment("A list of materials that will be able to damage and smite undead").translation("gui.consecration.config.holyMaterial").defineList("holyMaterial", Collections.singletonList("silver"), s -> s instanceof String);
            builder.pop();
            builder.push("undying");
            this.defaultUndead = builder.comment("Set to true to give default undead the undying trait").translation("gui.consecration.config.defaultUndead").define("defaultUndead", true);
            this.undeadList = builder.comment("A list of mobs that to classify as undead.\nFormat: 'modid:name'\nOptionally, add ';unholy' or ';absolute' to the end.\nUnholy mobs will not be smote by fire and absolute mobs will not be smote by anything.").translation("gui.consecration.config.undeadList").defineList("undeadList", ArrayList::new, s -> s instanceof String);
            this.damageReduction = builder.comment("Set undead natural damage reduction, in percent, against all non-holy damage").translation("gui.consecration.config.damageReduction").defineInRange("damageReduction", 0.8, 0.0, 1.0);
            this.healthRegen = builder.comment("Set undead natural health regen, in half-hearts per second").translation("gui.consecration.config.healthRegen").defineInRange("healthRegen", 1, 0, 1000);
            this.speedModifier = builder.comment("Set undead natural bonus speed modifier").translation("gui.consecration.config.speedModifier").defineInRange("speedModifier", 0.0, 0.0, 100.0);
            this.bystanderNerf = builder.comment("Set to true to have undead reduce damage against non-player non-holy entities").translation("gui.consecration.config.bystanderNerf").define("bystanderNerf", true);
            builder.pop();
        }
    }

    public static enum PermissionMode {
        BLACKLIST,
        WHITELIST;

    }
}

