/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.api.IHolyRegistry;
import top.theillusivec4.consecration.common.ConsecrationParser;

public class HolyRegistry
implements IHolyRegistry {
    private static Map<EntityType<?>, ConsecrationApi.UndeadType> undeadMap = new HashMap();
    private static List<BiFunction<LivingEntity, DamageSource, Boolean>> holyAttacks = new ArrayList<BiFunction<LivingEntity, DamageSource, Boolean>>();
    private static List<BiFunction<LivingEntity, DamageSource, Integer>> holyProtection = new ArrayList<BiFunction<LivingEntity, DamageSource, Integer>>();
    private static Set<EntityType<?>> holyEntities = new HashSet();
    private static Set<Effect> holyEffects = new HashSet<Effect>();
    private static Set<Item> holyItems = new HashSet<Item>();
    private static Set<Enchantment> holyEnchantments = new HashSet<Enchantment>();
    private static Set<String> holyDamage = new HashSet<String>();
    private static Set<String> holyMaterials = new HashSet<String>();

    @Override
    public void addHolyProtection(BiFunction<LivingEntity, DamageSource, Integer> func) {
        holyProtection.add(func);
    }

    @Override
    public List<BiFunction<LivingEntity, DamageSource, Integer>> getHolyProtection() {
        return ImmutableList.copyOf(holyProtection);
    }

    @Override
    public void addHolyMaterial(String material) {
        holyMaterials.add(material);
    }

    @Override
    public Set<String> getHolyMaterials() {
        return ImmutableSet.copyOf(holyMaterials);
    }

    @Override
    public void addHolyDamage(String damageType) {
        holyDamage.add(damageType);
    }

    @Override
    public Set<String> getHolyDamage() {
        return ImmutableSet.copyOf(holyDamage);
    }

    @Override
    public void addHolyEnchantment(String enchantment) {
        Enchantment type = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantment));
        if (type != null) {
            this.addHolyEnchantment(type);
        }
    }

    @Override
    public void addHolyEnchantment(Enchantment enchantment) {
        holyEnchantments.add(enchantment);
    }

    @Override
    public Set<Enchantment> getHolyEnchantments() {
        return ImmutableSet.copyOf(holyEnchantments);
    }

    @Override
    public void addHolyItem(String item) {
        Item type = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
        if (type != null) {
            this.addHolyItem(type);
        }
    }

    @Override
    public void addHolyItem(Item item) {
        holyItems.add(item);
    }

    @Override
    public Set<Item> getHolyItems() {
        return ImmutableSet.copyOf(holyItems);
    }

    @Override
    public void addHolyEffect(String potion) {
        Effect type = (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potion));
        if (type != null) {
            this.addHolyEffect(type);
        }
    }

    @Override
    public void addHolyEffect(Effect potion) {
        holyEffects.add(potion);
    }

    @Override
    public Set<Effect> getHolyEffects() {
        return ImmutableSet.copyOf(holyEffects);
    }

    @Override
    public void addHolyEntity(String entity) {
        EntityType.func_220327_a((String)entity).ifPresent(ConsecrationApi.getHolyRegistry()::addHolyEntity);
    }

    @Override
    public void addHolyEntity(EntityType<?> entityType) {
        holyEntities.add(entityType);
    }

    @Override
    public Set<EntityType<?>> getHolyEntities() {
        return ImmutableSet.copyOf(holyEntities);
    }

    @Override
    public void addHolyAttack(BiFunction<LivingEntity, DamageSource, Boolean> func) {
        holyAttacks.add(func);
    }

    @Override
    public List<BiFunction<LivingEntity, DamageSource, Boolean>> getHolyAttacks() {
        return ImmutableList.copyOf(holyAttacks);
    }

    @Override
    public void addUndead(String string) {
        ConsecrationParser.getUndeadType(string).ifPresent(tuple -> this.addUndead((EntityType)tuple.func_76341_a(), (ConsecrationApi.UndeadType)((Object)((Object)tuple.func_76340_b()))));
    }

    @Override
    public void addUndead(EntityType<?> entityType) {
        this.addUndead(entityType, ConsecrationApi.UndeadType.NORMAL);
    }

    @Override
    public void addUndead(EntityType<?> entityType, String undeadType) {
        if (undeadType.equals("unholy")) {
            this.addUndead(entityType, ConsecrationApi.UndeadType.UNHOLY);
        } else if (undeadType.equals("absolute")) {
            this.addUndead(entityType, ConsecrationApi.UndeadType.ABSOLUTE);
        } else {
            this.addUndead(entityType, ConsecrationApi.UndeadType.NORMAL);
        }
    }

    @Override
    public void addUndead(EntityType<?> entityType, ConsecrationApi.UndeadType undeadType) {
        undeadMap.putIfAbsent(entityType, undeadType);
    }

    @Override
    public Map<EntityType<?>, ConsecrationApi.UndeadType> getUndead() {
        return ImmutableMap.copyOf(undeadMap);
    }

    @Override
    public DamageSource causeHolyDamage(@Nonnull Entity entity) {
        return new EntityDamageSource("holy", entity).func_82726_p();
    }

    @Override
    public DamageSource causeIndirectHolyDamage(@Nonnull Entity source, @Nullable Entity indirect) {
        return new IndirectEntityDamageSource("holy", source, indirect).func_82726_p();
    }

    @Override
    public DamageSource causeHolyDamage() {
        return new DamageSource("holy").func_82726_p();
    }

    @Override
    public void clear() {
        undeadMap.clear();
        holyAttacks.clear();
        holyProtection.clear();
        holyEntities.clear();
        holyEffects.clear();
        holyItems.clear();
        holyEnchantments.clear();
        holyDamage.clear();
        holyMaterials.clear();
    }
}

