/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.consecration.common.integration;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import top.theillusivec4.consecration.api.ConsecrationApi;
import top.theillusivec4.consecration.common.integration.AbstractModule;

public class SilentGearModule
extends AbstractModule {
    @Override
    public void enqueueImc() {
        InterModComms.sendTo((String)"consecration", (String)"holy_attack", () -> (livingEntity, damageSource) -> {
            if (damageSource.func_76364_f() instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)damageSource.func_76364_f()).func_184614_ca();
                return SilentGearModule.containsHolyMaterial(stack);
            }
            return false;
        });
        InterModComms.sendTo((String)"consecration", (String)"holy_protection", () -> (livingEntity, damageSource) -> {
            int level = 0;
            for (ItemStack stack : livingEntity.func_184193_aE()) {
                if (!SilentGearModule.containsHolyMaterial(stack)) continue;
                ++level;
            }
            return level;
        });
    }

    private static boolean containsHolyMaterial(ItemStack stack) {
        if (GearHelper.isGear((ItemStack)stack)) {
            PartDataList data = GearData.getConstructionParts((ItemStack)stack);
            for (PartData partData : data) {
                ItemStack crafting = partData.getCraftingItem();
                CompoundNBT tag = crafting.func_77978_p();
                if (tag == null) continue;
                ListNBT list = tag.func_150295_c("Materials", 10);
                for (INBT inbt : list) {
                    CompoundNBT entry = (CompoundNBT)inbt;
                    if (!SilentGearModule.containsHolyMaterial(new ResourceLocation(entry.func_74779_i("ID")))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean containsHolyMaterial(ResourceLocation resourceLocation) {
        for (String mat : ConsecrationApi.getHolyRegistry().getHolyMaterials()) {
            String pattern = "^" + mat + "(\\b|[_-]\\w*)";
            if (!resourceLocation.func_110623_a().matches(pattern)) continue;
            return true;
        }
        return false;
    }
}

