/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import com.blamejared.controlling.client.gui.DisplayMode;
import com.blamejared.controlling.client.gui.GuiNewKeyBindingList;
import com.blamejared.controlling.client.gui.SearchType;
import com.blamejared.controlling.client.gui.SortOrder;
import java.util.Iterator;
import java.util.function.Predicate;
import net.minecraft.client.GameSettings;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiOptionSlider;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.config.GuiCheckBox;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewControls
extends GuiControls {
    private static final GameSettings.Options[] OPTIONS_ARR = new GameSettings.Options[]{GameSettings.Options.INVERT_MOUSE, GameSettings.Options.SENSITIVITY, GameSettings.Options.TOUCHSCREEN, GameSettings.Options.AUTO_JUMP};
    private GuiNewKeyBindingList keyBindingList;
    private GuiButton buttonReset;
    private final GuiScreen parentScreen;
    private final GameSettings options;
    private String lastSearch;
    private GuiTextField search;
    private DisplayMode displayMode;
    private SearchType searchType;
    private SortOrder sortOrder;
    private GuiButton buttonNone;
    private GuiButton buttonConflicting;
    private GuiCheckBox buttonKey;
    private GuiCheckBox buttonCat;
    private GuiButton buttonSort;

    public GuiNewControls(GuiScreen screen, GameSettings settings) {
        super(screen, settings);
        this.parentScreen = screen;
        this.options = settings;
    }

    protected void func_73866_w_() {
        this.keyBindingList = new GuiNewKeyBindingList(this, this.field_146297_k);
        this.field_195124_j.add(this.keyBindingList);
        this.func_195073_a((IGuiEventListener)this.keyBindingList);
        this.func_189646_b(new GuiButton(200, this.field_146294_l / 2 - 155 + 160, this.field_146295_m - 29, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiNewControls.this.field_146297_k.func_147108_a(GuiNewControls.this.parentScreen);
            }
        });
        this.buttonReset = this.func_189646_b(new GuiButton(201, this.field_146294_l / 2 - 155, this.field_146295_m - 29, 150, 20, I18n.func_135052_a((String)"controls.resetAll", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                for (KeyBinding keybinding : GuiNewControls.this.field_146297_k.field_71474_y.field_74324_K) {
                    keybinding.setToDefault();
                }
                KeyBinding.func_74508_b();
            }
        });
        this.buttonNone = this.func_189646_b(new GuiButton(2907, this.field_146294_l / 2 - 155 + 160 + 76, this.field_146295_m - 29 - 24, 75, 20, "Show Unbound"){

            public void func_194829_a(double mouseX, double mouseY) {
                if (GuiNewControls.this.displayMode == DisplayMode.NONE) {
                    ((GuiNewControls)GuiNewControls.this).buttonNone.field_146126_j = I18n.func_135052_a((String)"options.showNone", (Object[])new Object[0]);
                    GuiNewControls.this.displayMode = DisplayMode.ALL;
                } else {
                    GuiNewControls.this.displayMode = DisplayMode.NONE;
                    ((GuiNewControls)GuiNewControls.this).buttonNone.field_146126_j = I18n.func_135052_a((String)"options.showAll", (Object[])new Object[0]);
                    ((GuiNewControls)GuiNewControls.this).buttonConflicting.field_146126_j = I18n.func_135052_a((String)"options.showConflicts", (Object[])new Object[0]);
                }
                GuiNewControls.this.filterKeys();
            }
        });
        this.buttonConflicting = this.func_189646_b(new GuiButton(2906, this.field_146294_l / 2 - 155 + 160, this.field_146295_m - 29 - 24, 75, 20, "Show Conflicts"){

            public void func_194829_a(double mouseX, double mouseY) {
                if (GuiNewControls.this.displayMode == DisplayMode.CONFLICTING) {
                    ((GuiNewControls)GuiNewControls.this).buttonConflicting.field_146126_j = I18n.func_135052_a((String)"options.showConflicts", (Object[])new Object[0]);
                    GuiNewControls.this.displayMode = DisplayMode.ALL;
                } else {
                    GuiNewControls.this.displayMode = DisplayMode.CONFLICTING;
                    ((GuiNewControls)GuiNewControls.this).buttonConflicting.field_146126_j = "Show All";
                    ((GuiNewControls)GuiNewControls.this).buttonNone.field_146126_j = I18n.func_135052_a((String)"options.showNone", (Object[])new Object[0]);
                }
                GuiNewControls.this.filterKeys();
            }
        });
        this.search = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 154, this.field_146295_m - 29 - 23, 148, 18);
        this.buttonKey = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(2908, this.field_146294_l / 2 - 77 + 20, this.field_146295_m - 29 - 37, I18n.func_135052_a((String)"options.key", (Object[])new Object[0]), false){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                GuiNewControls.this.buttonCat.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.KEY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.buttonCat = (GuiCheckBox)this.func_189646_b((GuiButton)new GuiCheckBox(2909, this.field_146294_l / 2 - 77 + 20, this.field_146295_m - 29 - 50, I18n.func_135052_a((String)"options.category", (Object[])new Object[0]), false){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                GuiNewControls.this.buttonKey.setIsChecked(false);
                GuiNewControls.this.searchType = this.isChecked() ? SearchType.CATEGORY : SearchType.NAME;
                GuiNewControls.this.filterKeys();
            }
        });
        this.sortOrder = SortOrder.NONE;
        this.buttonSort = this.func_189646_b(new GuiButton(2910, this.field_146294_l / 2 - 155 + 160 + 76, this.field_146295_m - 29 - 24 - 24, 75, 20, I18n.func_135052_a((String)"options.sort", (Object[])new Object[0]) + ": " + this.sortOrder.getName()){

            public void func_194829_a(double mouseX, double mouseY) {
                super.func_194829_a(mouseX, mouseY);
                GuiNewControls.this.sortOrder = GuiNewControls.this.sortOrder.cycle();
                this.field_146126_j = I18n.func_135052_a((String)"options.sort", (Object[])new Object[0]) + ": " + GuiNewControls.this.sortOrder.getName();
                GuiNewControls.this.filterKeys();
            }
        });
        this.field_146495_a = I18n.func_135052_a((String)"controls.title", (Object[])new Object[0]);
        int i = 0;
        for (GameSettings.Options gamesettings$options : OPTIONS_ARR) {
            if (gamesettings$options.func_74380_a()) {
                this.func_189646_b((GuiButton)new GuiOptionSlider(gamesettings$options.func_74381_c(), this.field_146294_l / 2 - 155 + i % 2 * 160, 18 + 24 * (i >> 1), gamesettings$options));
            } else {
                this.func_189646_b((GuiButton)new GuiOptionButton(gamesettings$options.func_74381_c(), this.field_146294_l / 2 - 155 + i % 2 * 160, 18 + 24 * (i >> 1), gamesettings$options, this.options.func_74297_c(gamesettings$options)){

                    public void func_194829_a(double mouseX, double mouseY) {
                        GuiNewControls.this.options.func_74306_a(this.func_146136_c(), 1);
                        this.field_146126_j = GuiNewControls.this.options.func_74297_c(GameSettings.Options.func_74379_a((int)this.field_146127_k));
                    }
                });
            }
            ++i;
        }
        this.lastSearch = "";
        this.displayMode = DisplayMode.ALL;
        this.searchType = SearchType.NAME;
    }

    public boolean charTyped(char var1, int var2) {
        return this.search.charTyped(var1, var2);
    }

    public void func_73876_c() {
        this.search.func_146178_a();
        if (!this.lastSearch.equals(this.search.func_146179_b())) {
            this.filterKeys();
        }
    }

    public void filterKeys() {
        this.lastSearch = this.search.func_146179_b();
        this.keyBindingList.func_195074_b().clear();
        if (this.lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            this.keyBindingList.func_195074_b().addAll(this.keyBindingList.getAllEntries());
            return;
        }
        Predicate<GuiNewKeyBindingList.KeyEntry> filters = this.displayMode.getPredicate();
        switch (this.searchType) {
            case NAME: {
                filters = filters.and(keyEntry -> keyEntry.getKeyDesc().toLowerCase().contains(this.lastSearch.toLowerCase()));
                break;
            }
            case CATEGORY: {
                filters = filters.and(keyEntry -> keyEntry.getKeybinding().func_151466_e().toLowerCase().contains(this.lastSearch.toLowerCase()));
                break;
            }
            case KEY: {
                filters = filters.and(keyEntry -> keyEntry.getKeybinding().getKey().func_197936_a().toLowerCase().contains(this.lastSearch.toLowerCase()));
            }
        }
        for (GuiNewKeyBindingList.Entry entry : this.keyBindingList.getAllEntries()) {
            GuiNewKeyBindingList.KeyEntry keyEntry2;
            if (!(entry instanceof GuiNewKeyBindingList.KeyEntry) || !filters.test(keyEntry2 = (GuiNewKeyBindingList.KeyEntry)entry)) continue;
            this.keyBindingList.func_195074_b().add(entry);
        }
        this.sortOrder.sort(this.keyBindingList.func_195074_b());
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.keyBindingList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.field_146495_a, this.field_146294_l / 2, 8, 0xFFFFFF);
        boolean flag = false;
        for (KeyBinding keybinding : this.options.field_74324_K) {
            if (keybinding.func_197985_l()) continue;
            flag = true;
            break;
        }
        this.search.func_195608_a(mouseX, mouseY, partialTicks);
        this.buttonReset.field_146124_l = flag;
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_194828_a(mouseX, mouseY, partialTicks);
        }
        for (int j = 0; j < this.field_146293_o.size(); ++j) {
            ((GuiLabel)this.field_146293_o.get(j)).func_194997_a(mouseX, mouseY, partialTicks);
        }
        String text = I18n.func_135052_a((String)"options.search", (Object[])new Object[0]);
        this.field_146289_q.func_211126_b(text, (float)(this.field_146294_l / 2 - 77 - this.field_146289_q.func_78256_a(text) / 2), (float)(this.field_146295_m - 29 - 39), 0xFFFFFF);
    }

    public boolean mouseClicked(double mx, double my, int mb) {
        boolean valid;
        if (this.field_146491_f != null) {
            this.options.func_198014_a(this.field_146491_f, InputMappings.Type.MOUSE.func_197944_a(mb));
            this.field_146491_f = null;
            KeyBinding.func_74508_b();
            valid = true;
            this.search.func_146195_b(false);
        } else if (mb == 0 && this.keyBindingList.mouseClicked(mx, my, mb)) {
            this.func_195072_d(true);
            this.func_195073_a((IGuiEventListener)this.keyBindingList);
            valid = true;
            this.search.func_146195_b(false);
        } else {
            valid = this.search.mouseClicked(mx, my, mb);
            if (!valid && this.search.func_146206_l() && mb == 1) {
                this.search.func_146180_a("");
                valid = true;
            }
        }
        if (!valid) {
            IGuiEventListener listener;
            boolean clicked;
            Iterator childIter = this.func_195074_b().iterator();
            do {
                if (childIter.hasNext()) continue;
                return false;
            } while (!(clicked = (listener = (IGuiEventListener)childIter.next()).mouseClicked(mx, my, mb)));
            this.func_205725_b(listener);
            if (mb == 0) {
                this.func_195072_d(true);
            }
            valid = true;
        }
        return valid;
    }

    public boolean mouseReleased(double mx, double my, int mb) {
        if (mb == 0 && this.keyBindingList.mouseReleased(mx, my, mb)) {
            this.func_195072_d(false);
            return true;
        }
        if (this.search.func_146206_l()) {
            return this.search.mouseReleased(mx, my, mb);
        }
        this.func_195072_d(false);
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.search.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (this.field_146491_f != null) {
            if (p_keyPressed_1_ == 256) {
                this.field_146491_f.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputMappings.field_197958_a);
                this.options.func_198014_a(this.field_146491_f, InputMappings.field_197958_a);
            } else {
                this.field_146491_f.setKeyModifierAndCode(KeyModifier.getActiveModifier(), InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_));
                this.options.func_198014_a(this.field_146491_f, InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_));
            }
            if (!KeyModifier.isKeyCodeModifier((InputMappings.Input)this.field_146491_f.getKey())) {
                this.field_146491_f = null;
            }
            this.field_152177_g = Util.func_211177_b();
            KeyBinding.func_74508_b();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

