/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiControls;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class GuiNewKeyBindingList
extends GuiListExtended<Entry> {
    private final GuiControls controlsScreen;
    private final Minecraft mc;
    private int maxListLabelWidth;
    public List<Entry> allEntries;

    public GuiNewKeyBindingList(GuiControls controls, Minecraft mcIn) {
        super(mcIn, controls.field_146294_l + 45, controls.field_146295_m, 63, controls.field_146295_m - 80, 20);
        this.controlsScreen = controls;
        this.mc = mcIn;
        this.allEntries = new ArrayList<Entry>();
        Object[] akeybinding = (KeyBinding[])ArrayUtils.clone((Object[])mcIn.field_71474_y.field_74324_K);
        Arrays.sort(akeybinding);
        String s = null;
        for (Object keybinding : akeybinding) {
            int i;
            String s1 = keybinding.func_151466_e();
            if (!s1.equals(s)) {
                s = s1;
                this.add(new CategoryEntry(s1));
            }
            if ((i = mcIn.field_71466_p.func_78256_a(I18n.func_135052_a((String)keybinding.func_151464_g(), (Object[])new Object[0]))) > this.maxListLabelWidth) {
                this.maxListLabelWidth = i;
            }
            this.add(new KeyEntry((KeyBinding)keybinding));
        }
    }

    public List<Entry> getAllEntries() {
        return this.allEntries;
    }

    public void add(Entry ent) {
        this.func_195085_a(ent);
        this.allEntries.add(ent);
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 35;
    }

    public int func_148139_c() {
        return super.func_148139_c() + 32;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class KeyEntry
    extends Entry {
        private final KeyBinding keybinding;
        private final String keyDesc;
        private final GuiButton btnChangeKeyBinding;

        private KeyEntry(final KeyBinding name) {
            this.keybinding = name;
            this.keyDesc = I18n.func_135052_a((String)name.func_151464_g(), (Object[])new Object[0]);
            this.btnChangeKeyBinding = new GuiButton(0, 0, 0, 95, 20, I18n.func_135052_a((String)name.func_197978_k(), (Object[])new Object[0])){

                public void func_194829_a(double mouseX, double mouseY) {
                    ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f = name;
                }
            };
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            int i = this.func_195001_c();
            int j = this.func_195002_d();
            boolean flag = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).controlsScreen.field_146491_f == this.keybinding;
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_211126_b(this.keyDesc, (float)(j + 90 - GuiNewKeyBindingList.this.maxListLabelWidth), (float)(i + entryHeight / 2 - ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.field_78288_b / 2), 0xFFFFFF);
            this.btnChangeKeyBinding.field_146128_h = j + 105;
            this.btnChangeKeyBinding.field_146129_i = i;
            this.btnChangeKeyBinding.field_146126_j = this.keybinding.func_197978_k();
            boolean flag1 = false;
            boolean keyCodeModifierConflict = true;
            if (!this.keybinding.func_197986_j()) {
                for (KeyBinding keybinding : ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71474_y.field_74324_K) {
                    if (keybinding == this.keybinding || !this.keybinding.func_197983_b(keybinding)) continue;
                    flag1 = true;
                    keyCodeModifierConflict &= keybinding.hasKeyCodeModifierConflict(this.keybinding);
                }
            }
            if (flag) {
                this.btnChangeKeyBinding.field_146126_j = "\u00c2\u00a7f> \u00c2\u00a7e" + this.btnChangeKeyBinding.field_146126_j + "\u00c2\u00a7f <";
            } else if (flag1) {
                this.btnChangeKeyBinding.field_146126_j = (keyCodeModifierConflict ? "\u00c2\u00a76" : "\u00c2\u00a7c") + this.btnChangeKeyBinding.field_146126_j;
            }
            this.btnChangeKeyBinding.func_194828_a(mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            return this.btnChangeKeyBinding.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }

        public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
            return this.btnChangeKeyBinding.mouseReleased(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        }

        public KeyBinding getKeybinding() {
            return this.keybinding;
        }

        public String getKeyDesc() {
            return this.keyDesc;
        }

        public GuiButton getBtnChangeKeyBinding() {
            return this.btnChangeKeyBinding;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class Entry
    extends GuiListExtended.IGuiListEntry<Entry> {
    }

    @OnlyIn(value=Dist.CLIENT)
    public class CategoryEntry
    extends Entry {
        private final String labelText;
        private final int labelWidth;

        public CategoryEntry(String name) {
            this.labelText = I18n.func_135052_a((String)name, (Object[])new Object[0]);
            this.labelWidth = ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_78256_a(this.labelText);
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.func_211126_b(this.labelText, (float)(((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71462_r.field_146294_l / 2 - this.labelWidth / 2), (float)(this.func_195001_c() + entryHeight - ((GuiNewKeyBindingList)GuiNewKeyBindingList.this).mc.field_71466_p.field_78288_b - 1), 0xFFFFFF);
        }
    }
}

